package org.graylog2.telemetry.enterprise;

import java.time.ZonedDateTime;
import javax.annotation.processing.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TelemetryLicenseStatus extends TelemetryLicenseStatus {

  private final boolean violated;

  private final boolean expired;

  private final boolean valid;

  private final String subject;

  private final ZonedDateTime expirationDate;

  private final long trafficLimit;

  private AutoValue_TelemetryLicenseStatus(
      boolean violated,
      boolean expired,
      boolean valid,
      String subject,
      ZonedDateTime expirationDate,
      long trafficLimit) {
    this.violated = violated;
    this.expired = expired;
    this.valid = valid;
    this.subject = subject;
    this.expirationDate = expirationDate;
    this.trafficLimit = trafficLimit;
  }

  @Override
  public boolean violated() {
    return violated;
  }

  @Override
  public boolean expired() {
    return expired;
  }

  @Override
  public boolean valid() {
    return valid;
  }

  @Override
  public String subject() {
    return subject;
  }

  @Override
  public ZonedDateTime expirationDate() {
    return expirationDate;
  }

  @Override
  public long trafficLimit() {
    return trafficLimit;
  }

  @Override
  public String toString() {
    return "TelemetryLicenseStatus{"
        + "violated=" + violated + ", "
        + "expired=" + expired + ", "
        + "valid=" + valid + ", "
        + "subject=" + subject + ", "
        + "expirationDate=" + expirationDate + ", "
        + "trafficLimit=" + trafficLimit
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof TelemetryLicenseStatus) {
      TelemetryLicenseStatus that = (TelemetryLicenseStatus) o;
      return this.violated == that.violated()
          && this.expired == that.expired()
          && this.valid == that.valid()
          && this.subject.equals(that.subject())
          && this.expirationDate.equals(that.expirationDate())
          && this.trafficLimit == that.trafficLimit();
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= violated ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= expired ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= valid ? 1231 : 1237;
    h$ *= 1000003;
    h$ ^= subject.hashCode();
    h$ *= 1000003;
    h$ ^= expirationDate.hashCode();
    h$ *= 1000003;
    h$ ^= (int) ((trafficLimit >>> 32) ^ trafficLimit);
    return h$;
  }

  @Override
  public TelemetryLicenseStatus.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends TelemetryLicenseStatus.Builder {
    private Boolean violated;
    private Boolean expired;
    private Boolean valid;
    private String subject;
    private ZonedDateTime expirationDate;
    private Long trafficLimit;
    Builder() {
    }
    private Builder(TelemetryLicenseStatus source) {
      this.violated = source.violated();
      this.expired = source.expired();
      this.valid = source.valid();
      this.subject = source.subject();
      this.expirationDate = source.expirationDate();
      this.trafficLimit = source.trafficLimit();
    }
    @Override
    public TelemetryLicenseStatus.Builder violated(boolean violated) {
      this.violated = violated;
      return this;
    }
    @Override
    public TelemetryLicenseStatus.Builder expired(boolean expired) {
      this.expired = expired;
      return this;
    }
    @Override
    public TelemetryLicenseStatus.Builder valid(boolean valid) {
      this.valid = valid;
      return this;
    }
    @Override
    public TelemetryLicenseStatus.Builder subject(String subject) {
      if (subject == null) {
        throw new NullPointerException("Null subject");
      }
      this.subject = subject;
      return this;
    }
    @Override
    public TelemetryLicenseStatus.Builder expirationDate(ZonedDateTime expirationDate) {
      if (expirationDate == null) {
        throw new NullPointerException("Null expirationDate");
      }
      this.expirationDate = expirationDate;
      return this;
    }
    @Override
    public TelemetryLicenseStatus.Builder trafficLimit(long trafficLimit) {
      this.trafficLimit = trafficLimit;
      return this;
    }
    @Override
    public TelemetryLicenseStatus build() {
      String missing = "";
      if (this.violated == null) {
        missing += " violated";
      }
      if (this.expired == null) {
        missing += " expired";
      }
      if (this.valid == null) {
        missing += " valid";
      }
      if (this.subject == null) {
        missing += " subject";
      }
      if (this.expirationDate == null) {
        missing += " expirationDate";
      }
      if (this.trafficLimit == null) {
        missing += " trafficLimit";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_TelemetryLicenseStatus(
          this.violated,
          this.expired,
          this.valid,
          this.subject,
          this.expirationDate,
          this.trafficLimit);
    }
  }

}
