/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.systemnotification;

import com.google.inject.assistedinject.Assisted;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.inject.Inject;
import org.graylog.events.event.Event;
import org.graylog.events.event.EventFactory;
import org.graylog.events.event.EventWithContext;
import org.graylog.events.fields.FieldValue;
import org.graylog.events.fields.FieldValueType;
import org.graylog.events.processor.EventConsumer;
import org.graylog.events.processor.EventDefinition;
import org.graylog.events.processor.EventProcessor;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.processor.EventProcessorParameters;
import org.graylog.events.processor.systemnotification.SystemNotificationEventProcessorParameters;
import org.graylog2.plugin.MessageSummary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemNotificationEventProcessor
implements EventProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(SystemNotificationEventProcessor.class);
    private final EventDefinition eventDefinition;

    @Inject
    public SystemNotificationEventProcessor(@Assisted EventDefinition eventDefinition) {
        this.eventDefinition = eventDefinition;
    }

    @Override
    public void createEvents(EventFactory eventFactory, EventProcessorParameters processorParameters, EventConsumer<List<EventWithContext>> eventsConsumer) throws EventProcessorException {
        SystemNotificationEventProcessorParameters eventParameters = (SystemNotificationEventProcessorParameters)processorParameters;
        LOG.debug("Creating system event for notification: {}", (Object)eventParameters.notificationType());
        Object message = eventParameters.notificationType().name();
        if (eventParameters.notificationMessage() != null) {
            message = (String)message + ": " + eventParameters.notificationMessage();
        }
        Event event = eventFactory.createEvent(this.eventDefinition, eventParameters.timestamp(), (String)message);
        for (Map.Entry<String, Object> entry : eventParameters.notificationDetails().entrySet()) {
            event.setField(entry.getKey(), FieldValue.builder().dataType(FieldValueType.STRING).value(entry.getValue().toString()).build());
        }
        eventsConsumer.accept(List.of(EventWithContext.create(event)));
    }

    @Override
    public void sourceMessagesForEvent(Event event, Consumer<List<MessageSummary>> messageConsumer, long limit) throws EventProcessorException {
        LOG.debug("No source message available for {}", (Object)event);
    }

    public static interface Factory
    extends EventProcessor.Factory<SystemNotificationEventProcessor> {
        @Override
        public SystemNotificationEventProcessor create(EventDefinition var1);
    }
}

