/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.systemnotification;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.events.processor.systemnotification.SystemNotificationRenderService;
import org.graylog.events.processor.systemnotification.TemplateRenderRequest;
import org.graylog.events.processor.systemnotification.TemplateRenderResponse;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.notifications.Notification;
import org.graylog2.shared.rest.resources.RestResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(value="System/Notification/Message", description="Render system notification messages")
@Path(value="/system/notification/message")
@Consumes(value={"application/json"})
@Produces(value={"text/html", "text/plain"})
@RequiresAuthentication
public class SystemNotificationRenderResource
extends RestResource {
    private static final Logger LOG = LoggerFactory.getLogger(SystemNotificationRenderResource.class);
    private final SystemNotificationRenderService systemNotificationRenderService;

    @Inject
    public SystemNotificationRenderResource(SystemNotificationRenderService systemNotificationRenderService) {
        this.systemNotificationRenderService = systemNotificationRenderService;
    }

    @POST
    @NoAuditEvent(value="Doesn't change any data, only renders a notification message")
    @Path(value="/html/{type}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get HTML formatted message")
    public TemplateRenderResponse renderHtml(@ApiParam(name="type", required=true) @PathParam(value="type") Notification.Type type, @ApiParam(name="JSON body", required=false) TemplateRenderRequest request) {
        return this.render(type, null, SystemNotificationRenderService.Format.HTML, request);
    }

    @POST
    @NoAuditEvent(value="Doesn't change any data, only renders a notification message")
    @Path(value="/html/{type}/{key}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get HTML formatted message")
    public TemplateRenderResponse renderHtmlWithKey(@ApiParam(name="type", required=true) @PathParam(value="type") Notification.Type type, @ApiParam(name="key", required=true) @PathParam(value="key") String key, @ApiParam(name="JSON body", required=false) TemplateRenderRequest request) {
        return this.render(type, key, SystemNotificationRenderService.Format.HTML, request);
    }

    @POST
    @NoAuditEvent(value="Doesn't change any data, only renders a notification message")
    @Path(value="/plaintext/{type}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get plaintext formatted message")
    public TemplateRenderResponse renderPlainText(@ApiParam(name="type", required=true) @PathParam(value="type") Notification.Type type, @ApiParam(name="JSON body", required=false) TemplateRenderRequest request) {
        return this.render(type, null, SystemNotificationRenderService.Format.PLAINTEXT, request);
    }

    @POST
    @NoAuditEvent(value="Doesn't change any data, only renders a notification message")
    @Path(value="/plaintext/{type}/{key}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get plaintext formatted message")
    public TemplateRenderResponse renderPlainTextWithKey(@ApiParam(name="type", required=true) @PathParam(value="type") Notification.Type type, @ApiParam(name="key", required=true) @PathParam(value="key") String key, @ApiParam(name="JSON body", required=false) TemplateRenderRequest request) {
        return this.render(type, key, SystemNotificationRenderService.Format.PLAINTEXT, request);
    }

    private TemplateRenderResponse render(Notification.Type type, @Nullable String key, SystemNotificationRenderService.Format format, TemplateRenderRequest request) {
        HashMap<String, Object> values = request != null ? request.values() : new HashMap<String, Object>();
        SystemNotificationRenderService.RenderResponse renderResponse = this.systemNotificationRenderService.render(type, key, format, values);
        return TemplateRenderResponse.create(renderResponse.title, renderResponse.description);
    }
}

