/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil;

import com.github.rvesse.airline.annotations.Command;
import com.github.rvesse.airline.annotations.Option;
import java.io.FileOutputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.time.Duration;
import org.graylog.security.certutil.CertRequest;
import org.graylog.security.certutil.CertificateGenerator;
import org.graylog.security.certutil.KeyPair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.SystemConsole;
import org.graylog2.bootstrap.CliCommand;

@Command(name="ca", description="Manage certificate authority for data-node", groupNames={"certutil"})
public class CertutilCa
implements CliCommand {
    @Option(name={"--filename"}, description="Filename for the CA keystore")
    protected String keystoreFilename = "datanode-ca.p12";
    private final CommandLineConsole console;

    public CertutilCa() {
        this.console = new SystemConsole();
    }

    public CertutilCa(String keystoreFilename, CommandLineConsole console) {
        this.keystoreFilename = keystoreFilename;
        this.console = console;
    }

    @Override
    public void run() {
        try {
            this.console.printLine("This tool will generate a self-signed certificate authority for datanode");
            char[] password = this.console.readPassword("Enter CA password: ", new Object[0]);
            this.console.printLine("Generating datanode CA");
            Duration certificateValidity = Duration.ofDays(3650L);
            KeyPair rootCA = CertificateGenerator.generate(CertRequest.selfSigned("root").isCA(true).validity(certificateValidity));
            KeyPair intermediateCA = CertificateGenerator.generate(CertRequest.signed("ca", rootCA).isCA(true).validity(certificateValidity));
            KeyStore caKeystore = KeyStore.getInstance("PKCS12");
            caKeystore.load(null, null);
            caKeystore.setKeyEntry("root", rootCA.privateKey(), password, new X509Certificate[]{rootCA.certificate()});
            caKeystore.setKeyEntry("ca", intermediateCA.privateKey(), password, new X509Certificate[]{intermediateCA.certificate(), rootCA.certificate()});
            this.console.printLine("Private keys and certificates for root and intermediate CA generated");
            Path keystorePath = Path.of(this.keystoreFilename, new String[0]);
            try (FileOutputStream store = new FileOutputStream(keystorePath.toFile());){
                caKeystore.store(store, password);
                this.console.printLine("Keys and certificates stored in " + keystorePath.toAbsolutePath());
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate CA certificate", e);
        }
    }
}

