/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.grok;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.krakens.grok.api.Grok;
import io.krakens.grok.api.GrokCompiler;
import io.krakens.grok.api.exception.GrokException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.plugin.database.ValidationException;

abstract class GrokPatternServiceImpl
implements GrokPatternService {
    GrokPatternServiceImpl() {
    }

    @Override
    public Map<String, Object> match(GrokPattern pattern, String sampleData) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        Grok grok = grokCompiler.compile("%{" + pattern.name() + "}");
        return grok.match((CharSequence)sampleData).captureFlattened();
    }

    @Override
    public boolean validate(GrokPattern pattern) throws GrokException {
        Preconditions.checkNotNull((Object)pattern, (Object)"A pattern must be given");
        Preconditions.checkArgument((!pattern.name().contains(" ") ? 1 : 0) != 0, (Object)"Pattern name must not contain spaces");
        Set<GrokPattern> patterns = this.loadAll();
        boolean fieldsMissing = Strings.isNullOrEmpty((String)pattern.name()) || Strings.isNullOrEmpty((String)pattern.pattern());
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        grokCompiler.register(pattern.name(), pattern.pattern());
        grokCompiler.compile("%{" + pattern.name() + "}");
        return !fieldsMissing;
    }

    @Override
    public boolean validateAll(Collection<GrokPattern> newPatterns) throws GrokException {
        Set<GrokPattern> patterns = this.loadAll();
        GrokCompiler grokCompiler = GrokCompiler.newInstance();
        for (GrokPattern newPattern : newPatterns) {
            boolean fieldsMissing;
            boolean bl = fieldsMissing = Strings.isNullOrEmpty((String)newPattern.name()) || Strings.isNullOrEmpty((String)newPattern.pattern());
            if (fieldsMissing) {
                return false;
            }
            grokCompiler.register(newPattern.name(), newPattern.pattern());
        }
        for (GrokPattern storedPattern : patterns) {
            grokCompiler.register(storedPattern.name(), storedPattern.pattern());
        }
        for (GrokPattern newPattern : newPatterns) {
            grokCompiler.compile("%{" + newPattern.name() + "}");
        }
        return true;
    }

    protected void validateAllOrThrow(Collection<GrokPattern> newPatterns, GrokPatternService.ImportStrategy importStrategy) throws ValidationException {
        try {
            if (!this.validateAll(newPatterns)) {
                throw new ValidationException("Patterns invalid.");
            }
        }
        catch (GrokException | PatternSyntaxException e) {
            throw new ValidationException("Invalid patterns.\n" + e.getMessage());
        }
        if (importStrategy == GrokPatternService.ImportStrategy.DROP_ALL_EXISTING) {
            this.deleteAll();
        }
    }
}

