/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.cluster;

import com.codahale.metrics.annotation.Timed;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.time.Duration;
import java.util.concurrent.ExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.cluster.NodeService;
import org.graylog2.rest.RemoteInterfaceProvider;
import org.graylog2.rest.models.system.metrics.requests.MetricsReadRequest;
import org.graylog2.shared.rest.resources.ProxiedResource;
import org.graylog2.shared.rest.resources.system.RemoteMetricsResource;

@RequiresAuthentication
@Api(value="Cluster/Metrics", description="Cluster-wide Internal Graylog metrics")
@Path(value="/cluster/metrics")
@Produces(value={"application/json"})
public class ClusterMetricsResource
extends ProxiedResource {
    private final Duration callTimeout;

    @Inject
    public ClusterMetricsResource(NodeService nodeService, RemoteInterfaceProvider remoteInterfaceProvider, @Context HttpHeaders httpHeaders, @Named(value="proxiedRequestsExecutorService") ExecutorService executorService, @Named(value="proxied_requests_default_call_timeout") com.github.joschi.jadconfig.util.Duration defaultCallTimeout) {
        super(httpHeaders, nodeService, remoteInterfaceProvider, executorService);
        this.callTimeout = Duration.ofMillis(Math.min(defaultCallTimeout.toMilliseconds(), 1000L));
    }

    @POST
    @Timed
    @Path(value="/multiple")
    @ApiOperation(value="Get all metrics of all nodes in the cluster")
    @ApiResponses(value={@ApiResponse(code=400, message="Malformed body")})
    @NoAuditEvent(value="only used to retrieve metrics of all nodes")
    public void multipleMetricsAllNodes(@ApiParam(name="Requested metrics", required=true) @Valid @NotNull MetricsReadRequest request, @Suspended AsyncResponse asyncResponse) {
        try {
            String string = this.getAuthenticationToken();
        }
        catch (NotAuthorizedException e) {
            this.processAsync(asyncResponse, () -> ((NotAuthorizedException)e).getResponse());
            return;
        }
        this.processAsync(asyncResponse, () -> this.stripCallResult(this.requestOnAllNodes(RemoteMetricsResource.class, (RemoteInterfaceType r) -> r.multipleMetrics(request), this.callTimeout)));
    }
}

