/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus.mapping;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.metrics.prometheus.mapping.MetricMapping;
import org.graylog.metrics.prometheus.mapping.PrometheusMappingConfig;
import org.graylog2.jackson.DeserializationProblemHandlerModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMappingConfigLoader {
    private static final Logger log = LoggerFactory.getLogger(PrometheusMappingConfigLoader.class);
    private final ObjectMapper ymlMapper;
    private final Map<String, MetricMapping.Factory<? extends MetricMapping>> metricMappingFactories;

    @Inject
    public PrometheusMappingConfigLoader(Map<String, MetricMapping.Factory<? extends MetricMapping>> metricMappingFactories) {
        this.metricMappingFactories = metricMappingFactories;
        this.ymlMapper = new ObjectMapper((JsonFactory)new YAMLFactory()).registerModule((Module)new DeserializationProblemHandlerModule());
    }

    public Set<MapperConfig> load(InputStream inputStream) throws IOException {
        PrometheusMappingConfig config = (PrometheusMappingConfig)this.ymlMapper.readValue(inputStream, PrometheusMappingConfig.class);
        return config.metricMappingConfigs().stream().flatMap(this::mapMetric).collect(Collectors.toSet());
    }

    @Nullable
    private Stream<MapperConfig> mapMetric(MetricMapping.Config config) {
        MetricMapping.Factory<? extends MetricMapping> factory = this.metricMappingFactories.get(config.type());
        if (factory == null) {
            log.error("Missing handler to process mapping for metric <{}> of type <{}>. Skipping mapping.", (Object)config.metricName(), (Object)config.type());
            return Stream.empty();
        }
        return factory.create(config).toMapperConfigs().stream();
    }
}

