/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.MapBinder;
import org.graylog.plugins.pipelineprocessor.ast.functions.Function;
import org.graylog.plugins.pipelineprocessor.functions.FromInput;
import org.graylog.plugins.pipelineprocessor.functions.GrokExists;
import org.graylog.plugins.pipelineprocessor.functions.IsNotNull;
import org.graylog.plugins.pipelineprocessor.functions.IsNull;
import org.graylog.plugins.pipelineprocessor.functions.conversion.BooleanConversion;
import org.graylog.plugins.pipelineprocessor.functions.conversion.DoubleConversion;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsBoolean;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsCollection;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsDouble;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsList;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsLong;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsMap;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsNumber;
import org.graylog.plugins.pipelineprocessor.functions.conversion.IsString;
import org.graylog.plugins.pipelineprocessor.functions.conversion.LongConversion;
import org.graylog.plugins.pipelineprocessor.functions.conversion.MapConversion;
import org.graylog.plugins.pipelineprocessor.functions.conversion.StringConversion;
import org.graylog.plugins.pipelineprocessor.functions.dates.DateConversion;
import org.graylog.plugins.pipelineprocessor.functions.dates.FlexParseDate;
import org.graylog.plugins.pipelineprocessor.functions.dates.FormatDate;
import org.graylog.plugins.pipelineprocessor.functions.dates.IsDate;
import org.graylog.plugins.pipelineprocessor.functions.dates.Now;
import org.graylog.plugins.pipelineprocessor.functions.dates.ParseDate;
import org.graylog.plugins.pipelineprocessor.functions.dates.ParseUnixMilliseconds;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Days;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Hours;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.IsPeriod;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Millis;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Minutes;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Months;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.PeriodParseFunction;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Seconds;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Weeks;
import org.graylog.plugins.pipelineprocessor.functions.dates.periods.Years;
import org.graylog.plugins.pipelineprocessor.functions.debug.Debug;
import org.graylog.plugins.pipelineprocessor.functions.debug.MetricCounterIncrement;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base16Decode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base16Encode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base32Decode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base32Encode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base32HumanDecode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base32HumanEncode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base64Decode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base64Encode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base64UrlDecode;
import org.graylog.plugins.pipelineprocessor.functions.encoding.Base64UrlEncode;
import org.graylog.plugins.pipelineprocessor.functions.hashing.CRC32;
import org.graylog.plugins.pipelineprocessor.functions.hashing.CRC32C;
import org.graylog.plugins.pipelineprocessor.functions.hashing.MD5;
import org.graylog.plugins.pipelineprocessor.functions.hashing.Murmur3_128;
import org.graylog.plugins.pipelineprocessor.functions.hashing.Murmur3_32;
import org.graylog.plugins.pipelineprocessor.functions.hashing.SHA1;
import org.graylog.plugins.pipelineprocessor.functions.hashing.SHA256;
import org.graylog.plugins.pipelineprocessor.functions.hashing.SHA512;
import org.graylog.plugins.pipelineprocessor.functions.ips.CidrMatch;
import org.graylog.plugins.pipelineprocessor.functions.ips.IpAddressConversion;
import org.graylog.plugins.pipelineprocessor.functions.ips.IsIp;
import org.graylog.plugins.pipelineprocessor.functions.json.IsJson;
import org.graylog.plugins.pipelineprocessor.functions.json.JsonFlatten;
import org.graylog.plugins.pipelineprocessor.functions.json.JsonParse;
import org.graylog.plugins.pipelineprocessor.functions.json.SelectJsonPath;
import org.graylog.plugins.pipelineprocessor.functions.lookup.Lookup;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupAddStringList;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupAssignTtl;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupClearKey;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupHasValue;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupRemoveStringList;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupSetStringList;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupSetValue;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupStringList;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupStringListContains;
import org.graylog.plugins.pipelineprocessor.functions.lookup.LookupValue;
import org.graylog.plugins.pipelineprocessor.functions.messages.CloneMessage;
import org.graylog.plugins.pipelineprocessor.functions.messages.CreateMessage;
import org.graylog.plugins.pipelineprocessor.functions.messages.DropMessage;
import org.graylog.plugins.pipelineprocessor.functions.messages.HasField;
import org.graylog.plugins.pipelineprocessor.functions.messages.NormalizeFields;
import org.graylog.plugins.pipelineprocessor.functions.messages.RemoveField;
import org.graylog.plugins.pipelineprocessor.functions.messages.RemoveFromStream;
import org.graylog.plugins.pipelineprocessor.functions.messages.RenameField;
import org.graylog.plugins.pipelineprocessor.functions.messages.RouteToStream;
import org.graylog.plugins.pipelineprocessor.functions.messages.SetField;
import org.graylog.plugins.pipelineprocessor.functions.messages.SetFields;
import org.graylog.plugins.pipelineprocessor.functions.messages.StreamCacheService;
import org.graylog.plugins.pipelineprocessor.functions.messages.TrafficAccountingSize;
import org.graylog.plugins.pipelineprocessor.functions.strings.Abbreviate;
import org.graylog.plugins.pipelineprocessor.functions.strings.Capitalize;
import org.graylog.plugins.pipelineprocessor.functions.strings.Concat;
import org.graylog.plugins.pipelineprocessor.functions.strings.Contains;
import org.graylog.plugins.pipelineprocessor.functions.strings.EndsWith;
import org.graylog.plugins.pipelineprocessor.functions.strings.FirstNonNull;
import org.graylog.plugins.pipelineprocessor.functions.strings.GrokMatch;
import org.graylog.plugins.pipelineprocessor.functions.strings.Join;
import org.graylog.plugins.pipelineprocessor.functions.strings.KeyValue;
import org.graylog.plugins.pipelineprocessor.functions.strings.Length;
import org.graylog.plugins.pipelineprocessor.functions.strings.Lowercase;
import org.graylog.plugins.pipelineprocessor.functions.strings.RegexMatch;
import org.graylog.plugins.pipelineprocessor.functions.strings.RegexReplace;
import org.graylog.plugins.pipelineprocessor.functions.strings.Replace;
import org.graylog.plugins.pipelineprocessor.functions.strings.Split;
import org.graylog.plugins.pipelineprocessor.functions.strings.StartsWith;
import org.graylog.plugins.pipelineprocessor.functions.strings.StringEntropy;
import org.graylog.plugins.pipelineprocessor.functions.strings.Substring;
import org.graylog.plugins.pipelineprocessor.functions.strings.Swapcase;
import org.graylog.plugins.pipelineprocessor.functions.strings.Uncapitalize;
import org.graylog.plugins.pipelineprocessor.functions.strings.Uppercase;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogFacilityConversion;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogLevelConversion;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogPriorityConversion;
import org.graylog.plugins.pipelineprocessor.functions.syslog.SyslogPriorityToStringConversion;
import org.graylog.plugins.pipelineprocessor.functions.urls.IsUrl;
import org.graylog.plugins.pipelineprocessor.functions.urls.UrlConversion;
import org.graylog.plugins.pipelineprocessor.functions.urls.UrlDecode;
import org.graylog.plugins.pipelineprocessor.functions.urls.UrlEncode;
import org.graylog2.plugin.PluginModule;

public class ProcessorFunctionsModule
extends PluginModule {
    protected void configure() {
        this.addMessageProcessorFunction("to_bool", BooleanConversion.class);
        this.addMessageProcessorFunction("to_double", DoubleConversion.class);
        this.addMessageProcessorFunction("to_long", LongConversion.class);
        this.addMessageProcessorFunction("to_string", StringConversion.class);
        this.addMessageProcessorFunction("to_map", MapConversion.class);
        this.addMessageProcessorFunction("is_bool", IsBoolean.class);
        this.addMessageProcessorFunction("is_number", IsNumber.class);
        this.addMessageProcessorFunction("is_double", IsDouble.class);
        this.addMessageProcessorFunction("is_long", IsLong.class);
        this.addMessageProcessorFunction("is_string", IsString.class);
        this.addMessageProcessorFunction("is_collection", IsCollection.class);
        this.addMessageProcessorFunction("is_list", IsList.class);
        this.addMessageProcessorFunction("is_map", IsMap.class);
        this.addMessageProcessorFunction("is_date", IsDate.class);
        this.addMessageProcessorFunction("is_period", IsPeriod.class);
        this.addMessageProcessorFunction("is_ip", IsIp.class);
        this.addMessageProcessorFunction("is_json", IsJson.class);
        this.addMessageProcessorFunction("is_url", IsUrl.class);
        this.addMessageProcessorFunction("has_field", HasField.class);
        this.addMessageProcessorFunction("set_field", SetField.class);
        this.addMessageProcessorFunction("set_fields", SetFields.class);
        this.addMessageProcessorFunction("rename_field", RenameField.class);
        this.addMessageProcessorFunction("remove_field", RemoveField.class);
        this.addMessageProcessorFunction("normalize_fields", NormalizeFields.class);
        this.addMessageProcessorFunction("drop_message", DropMessage.class);
        this.addMessageProcessorFunction("create_message", CreateMessage.class);
        this.addMessageProcessorFunction("clone_message", CloneMessage.class);
        this.addMessageProcessorFunction("remove_from_stream", RemoveFromStream.class);
        this.addMessageProcessorFunction("route_to_stream", RouteToStream.class);
        this.addMessageProcessorFunction("traffic_accounting_size", TrafficAccountingSize.class);
        this.serviceBinder().addBinding().to(StreamCacheService.class).in(Scopes.SINGLETON);
        this.addMessageProcessorFunction("from_input", FromInput.class);
        this.addMessageProcessorFunction("regex", RegexMatch.class);
        this.addMessageProcessorFunction("regex_replace", RegexReplace.class);
        this.addMessageProcessorFunction("grok", GrokMatch.class);
        this.addMessageProcessorFunction("grok_exists", GrokExists.class);
        this.addMessageProcessorFunction("abbreviate", Abbreviate.class);
        this.addMessageProcessorFunction("capitalize", Capitalize.class);
        this.addMessageProcessorFunction("contains", Contains.class);
        this.addMessageProcessorFunction("ends_with", EndsWith.class);
        this.addMessageProcessorFunction("lowercase", Lowercase.class);
        this.addMessageProcessorFunction("substring", Substring.class);
        this.addMessageProcessorFunction("swapcase", Swapcase.class);
        this.addMessageProcessorFunction("uncapitalize", Uncapitalize.class);
        this.addMessageProcessorFunction("uppercase", Uppercase.class);
        this.addMessageProcessorFunction("concat", Concat.class);
        this.addMessageProcessorFunction("key_value", KeyValue.class);
        this.addMessageProcessorFunction("join", Join.class);
        this.addMessageProcessorFunction("split", Split.class);
        this.addMessageProcessorFunction("starts_with", StartsWith.class);
        this.addMessageProcessorFunction("replace", Replace.class);
        this.addMessageProcessorFunction("length", Length.class);
        this.addMessageProcessorFunction("first_non_null", FirstNonNull.class);
        this.addMessageProcessorFunction("string_entropy", StringEntropy.class);
        this.addMessageProcessorFunction("parse_json", JsonParse.class);
        this.addMessageProcessorFunction("flatten_json", JsonFlatten.class);
        this.addMessageProcessorFunction("select_jsonpath", SelectJsonPath.class);
        this.addMessageProcessorFunction("to_date", DateConversion.class);
        this.addMessageProcessorFunction("now", Now.class);
        this.addMessageProcessorFunction("parse_date", ParseDate.class);
        this.addMessageProcessorFunction("parse_unix_milliseconds", ParseUnixMilliseconds.class);
        this.addMessageProcessorFunction("flex_parse_date", FlexParseDate.class);
        this.addMessageProcessorFunction("format_date", FormatDate.class);
        this.addMessageProcessorFunction("years", Years.class);
        this.addMessageProcessorFunction("months", Months.class);
        this.addMessageProcessorFunction("weeks", Weeks.class);
        this.addMessageProcessorFunction("days", Days.class);
        this.addMessageProcessorFunction("hours", Hours.class);
        this.addMessageProcessorFunction("minutes", Minutes.class);
        this.addMessageProcessorFunction("seconds", Seconds.class);
        this.addMessageProcessorFunction("millis", Millis.class);
        this.addMessageProcessorFunction("period", PeriodParseFunction.class);
        this.addMessageProcessorFunction("crc32", CRC32.class);
        this.addMessageProcessorFunction("crc32c", CRC32C.class);
        this.addMessageProcessorFunction("md5", MD5.class);
        this.addMessageProcessorFunction("murmur3_32", Murmur3_32.class);
        this.addMessageProcessorFunction("murmur3_128", Murmur3_128.class);
        this.addMessageProcessorFunction("sha1", SHA1.class);
        this.addMessageProcessorFunction("sha256", SHA256.class);
        this.addMessageProcessorFunction("sha512", SHA512.class);
        this.addMessageProcessorFunction("base16_encode", Base16Encode.class);
        this.addMessageProcessorFunction("base16_decode", Base16Decode.class);
        this.addMessageProcessorFunction("base32_encode", Base32Encode.class);
        this.addMessageProcessorFunction("base32_decode", Base32Decode.class);
        this.addMessageProcessorFunction("base32human_encode", Base32HumanEncode.class);
        this.addMessageProcessorFunction("base32human_decode", Base32HumanDecode.class);
        this.addMessageProcessorFunction("base64_encode", Base64Encode.class);
        this.addMessageProcessorFunction("base64_decode", Base64Decode.class);
        this.addMessageProcessorFunction("base64url_encode", Base64UrlEncode.class);
        this.addMessageProcessorFunction("base64url_decode", Base64UrlDecode.class);
        this.addMessageProcessorFunction("cidr_match", CidrMatch.class);
        this.addMessageProcessorFunction("to_ip", IpAddressConversion.class);
        this.addMessageProcessorFunction("is_null", IsNull.class);
        this.addMessageProcessorFunction("is_not_null", IsNotNull.class);
        this.addMessageProcessorFunction("to_url", UrlConversion.class);
        this.addMessageProcessorFunction("urldecode", UrlDecode.class);
        this.addMessageProcessorFunction("urlencode", UrlEncode.class);
        this.addMessageProcessorFunction("syslog_facility", SyslogFacilityConversion.class);
        this.addMessageProcessorFunction("syslog_level", SyslogLevelConversion.class);
        this.addMessageProcessorFunction("expand_syslog_priority", SyslogPriorityConversion.class);
        this.addMessageProcessorFunction("expand_syslog_priority_as_string", SyslogPriorityToStringConversion.class);
        this.addMessageProcessorFunction("lookup", Lookup.class);
        this.addMessageProcessorFunction("lookup_value", LookupValue.class);
        this.addMessageProcessorFunction("lookup_has_value", LookupHasValue.class);
        this.addMessageProcessorFunction("lookup_string_list", LookupStringList.class);
        this.addMessageProcessorFunction("lookup_set_value", LookupSetValue.class);
        this.addMessageProcessorFunction("lookup_clear_key", LookupClearKey.class);
        this.addMessageProcessorFunction("lookup_set_string_list", LookupSetStringList.class);
        this.addMessageProcessorFunction("lookup_add_string_list", LookupAddStringList.class);
        this.addMessageProcessorFunction("lookup_remove_string_list", LookupRemoveStringList.class);
        this.addMessageProcessorFunction("lookup_string_list_contains", LookupStringListContains.class);
        this.addMessageProcessorFunction("lookup_assign_ttl", LookupAssignTtl.class);
        this.addMessageProcessorFunction("debug", Debug.class);
        this.addMessageProcessorFunction("metric_counter_inc", MetricCounterIncrement.class);
    }

    protected void addMessageProcessorFunction(String name, Class<? extends Function<?>> functionClass) {
        ProcessorFunctionsModule.addMessageProcessorFunction(this.binder(), name, functionClass);
    }

    public static MapBinder<String, Function<?>> processorFunctionBinder(Binder binder) {
        return MapBinder.newMapBinder((Binder)binder, (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<Function<?>>(){});
    }

    public static void addMessageProcessorFunction(Binder binder, String name, Class<? extends Function<?>> functionClass) {
        ProcessorFunctionsModule.processorFunctionBinder(binder).addBinding((Object)name).to(functionClass);
    }
}

