/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.TypeLiteral;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.JacksonJsonNodeJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class SelectJsonPath
extends AbstractFunction<Map<String, Object>> {
    public static final String NAME = "select_jsonpath";
    private final ObjectMapper objectMapper;
    private final Configuration configuration;
    private final ParameterDescriptor<Object, Object> jsonParam;
    private final ParameterDescriptor<Map<String, String>, Map<String, JsonPath>> pathsParam;

    @Inject
    public SelectJsonPath(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.configuration = Configuration.builder().options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).jsonProvider((JsonProvider)new JacksonJsonNodeJsonProvider(objectMapper)).build();
        this.jsonParam = ParameterDescriptor.type("json", Object.class).description("A parsed JSON tree or String representation of a JSON tree").build();
        this.pathsParam = ParameterDescriptor.type("paths", new TypeLiteral<Map<String, String>>(){}.getRawType(), new TypeLiteral<Map<String, JsonPath>>(){}.getRawType()).transform(inputMap -> inputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> JsonPath.compile((String)((String)e.getValue()), (Predicate[])new Predicate[0])))).description("A map of names to a JsonPath expression, see http://jsonpath.com").build();
    }

    @Override
    public Map<String, Object> evaluate(FunctionArgs args, EvaluationContext context) {
        Object jsonObj = this.jsonParam.required(args, context);
        JsonNode json = null;
        if (jsonObj instanceof JsonNode) {
            JsonNode jsonNode;
            json = jsonNode = (JsonNode)jsonObj;
        } else if (jsonObj instanceof String) {
            String jsonString = (String)jsonObj;
            try {
                json = this.objectMapper.readTree(jsonString);
            }
            catch (JsonProcessingException e) {
                log.warn(context.pipelineErrorMessage("Unable to parse JSON"), (Throwable)e);
            }
        } else {
            throw new IllegalArgumentException(context.pipelineErrorMessage("`json` parameter must be a parsed JSON tree or String representation of a JSON tree"));
        }
        Map<String, JsonPath> paths = this.pathsParam.required(args, context);
        if (json == null || paths == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Map.Entry<String, JsonPath> entry : paths.entrySet()) {
            map.put(entry.getKey(), this.unwrapJsonNode(entry.getValue().read((Object)json, this.configuration)));
        }
        return map;
    }

    @Nullable
    private Object unwrapJsonNode(Object value) {
        if (!(value instanceof JsonNode)) {
            return value;
        }
        JsonNode read = (JsonNode)value;
        switch (read.getNodeType()) {
            case ARRAY: {
                return ImmutableList.copyOf((Iterator)read.elements());
            }
            case BINARY: {
                try {
                    return read.binaryValue();
                }
                catch (IOException e) {
                    return null;
                }
            }
            case BOOLEAN: {
                return read.booleanValue();
            }
            case MISSING: 
            case NULL: {
                return null;
            }
            case NUMBER: {
                return read.numberValue();
            }
            case OBJECT: {
                return read;
            }
            case POJO: {
                return read;
            }
            case STRING: {
                return read.textValue();
            }
        }
        return read;
    }

    @Override
    public FunctionDescriptor<Map<String, Object>> descriptor() {
        return FunctionDescriptor.builder().name(NAME).returnType(new TypeLiteral<Map<String, Object>>(){}.getRawType()).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.jsonParam, this.pathsParam)).description("Selects a map of fields containing the result of their JsonPath expressions").build();
    }
}

