/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.threatintel.adapters.abusech;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import org.graylog.plugins.threatintel.adapters.abusech.$AutoValue_AbuseChRansomAdapter_Config;
import org.graylog.plugins.threatintel.adapters.abusech.BlocklistType;
import org.graylog.plugins.threatintel.tools.AdapterDisabledException;
import org.graylog2.plugin.lookup.LookupCachePurge;
import org.graylog2.plugin.lookup.LookupDataAdapter;
import org.graylog2.plugin.lookup.LookupDataAdapterConfiguration;
import org.graylog2.plugin.lookup.LookupResult;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbuseChRansomAdapter
extends LookupDataAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(AbuseChRansomAdapter.class);
    private static final int REFRESH_INTERVAL = Period.minutes((int)5).toStandardSeconds().getSeconds() / 2;
    public static final String NAME = "abuse-ch-ransom";

    @Inject
    public AbuseChRansomAdapter(@Assisted(value="id") String id, @Assisted(value="name") String name, @Assisted LookupDataAdapterConfiguration config, MetricRegistry metricRegistry) {
        super(id, name, config, metricRegistry);
    }

    @Override
    public void doStart() throws Exception {
        throw new AdapterDisabledException("The abuse.ch Ransomware Tracker was shut down on 2019-12-08. This Data Adapter should be deleted.");
    }

    @Override
    protected void doStop() throws Exception {
    }

    @Override
    public Duration refreshInterval() {
        return Duration.ZERO;
    }

    @Override
    protected void doRefresh(LookupCachePurge cachePurge) throws Exception {
        throw new AdapterDisabledException("The abuse.ch Ransomware Tracker was shut down on 2019-12-08. This Data Adapter should be deleted.");
    }

    @Override
    protected LookupResult doGet(Object key) {
        return LookupResult.empty();
    }

    @Override
    public void set(Object key, Object value) {
    }

    @JsonAutoDetect
    @JsonDeserialize(builder=$AutoValue_AbuseChRansomAdapter_Config.Builder.class)
    @JsonTypeName(value="abuse-ch-ransom")
    @AutoValue
    public static abstract class Config
    implements LookupDataAdapterConfiguration {
        public static Builder builder() {
            return new $AutoValue_AbuseChRansomAdapter_Config.Builder();
        }

        @Override
        @JsonProperty(value="type")
        public abstract String type();

        @JsonProperty(value="refresh_interval")
        @Min(value=150L)
        public abstract @Min(value=150L) long refreshInterval();

        @Nullable
        @JsonProperty(value="refresh_interval_unit")
        public abstract TimeUnit refreshIntervalUnit();

        @JsonProperty(value="blocklist_type")
        public abstract BlocklistType blocklistType();

        @Override
        public Optional<Multimap<String, String>> validate() {
            ArrayListMultimap errors = ArrayListMultimap.create();
            return errors.isEmpty() ? Optional.empty() : Optional.of(errors);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            @JsonProperty(value="type")
            public abstract Builder type(String var1);

            @JsonProperty(value="refresh_interval")
            public abstract Builder refreshInterval(long var1);

            @JsonProperty(value="blocklist_type")
            public abstract Builder blocklistType(BlocklistType var1);

            @JsonProperty(value="refresh_interval_unit")
            public abstract Builder refreshIntervalUnit(@Nullable TimeUnit var1);

            public abstract Config build();
        }
    }

    public static class Descriptor
    extends LookupDataAdapter.Descriptor<Config> {
        public Descriptor() {
            super(AbuseChRansomAdapter.NAME, Config.class);
        }

        @Override
        public Config defaultConfiguration() {
            return Config.builder().type(AbuseChRansomAdapter.NAME).refreshInterval(REFRESH_INTERVAL).blocklistType(BlocklistType.DOMAINS).build();
        }
    }

    public static interface Factory
    extends LookupDataAdapter.Factory<AbuseChRansomAdapter> {
        @Override
        public AbuseChRansomAdapter create(@Assisted(value="id") String var1, @Assisted(value="name") String var2, LookupDataAdapterConfiguration var3);

        @Override
        public Descriptor getDescriptor();
    }
}

