/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.export;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.plugins.views.search.export.SimpleMessage;
import org.graylog.plugins.views.search.export.SimpleMessageChunk;
import org.graylog2.plugin.Tools;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ExportBackend {
    public static final Logger LOG = LoggerFactory.getLogger(ExportBackend.class);

    public void run(ExportMessagesCommand var1, Consumer<SimpleMessageChunk> var2);

    default public Object valueFrom(Map source, String name, DateTimeZone timeZone) {
        if (name.equals("timestamp")) {
            return this.fixTimestampFormat(source.get("timestamp"), timeZone);
        }
        return source.get(name);
    }

    default public Object fixTimestampFormat(Object rawTimestamp, DateTimeZone timeZone) {
        try {
            DateTime parsed = Tools.ES_DATE_FORMAT_FORMATTER.parseDateTime(String.valueOf(rawTimestamp));
            return parsed.withZone(timeZone).toString();
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Could not parse timestamp {}", rawTimestamp, (Object)e);
            return rawTimestamp;
        }
    }

    default public SimpleMessage buildHitWithAllFields(Map source, String index, DateTimeZone timeZone) {
        LinkedHashMap<String, Object> fields = new LinkedHashMap<String, Object>();
        for (Object key : source.keySet()) {
            String name = (String)key;
            Object value = this.valueFrom(source, name, timeZone);
            fields.put(name, value);
        }
        fields.put("_id", UUID.randomUUID().toString());
        return SimpleMessage.from(index, fields);
    }
}

