/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.graylog.plugins.views.search.Parameter;
import org.graylog.plugins.views.search.rest.AutoValue_ExecutionState;
import org.graylog.plugins.views.search.rest.ExecutionStateGlobalOverride;

@JsonAutoDetect
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class ExecutionState {
    @JsonProperty
    public abstract ImmutableMap<String, Parameter.Binding> parameterBindings();

    @JsonProperty
    public abstract ImmutableMap<String, ExecutionStateGlobalOverride> queries();

    @JsonProperty
    public abstract ExecutionStateGlobalOverride globalOverride();

    @JsonProperty
    public abstract ImmutableMap<String, Object> additionalParameters();

    public static ExecutionState empty() {
        return ExecutionState.builder().build();
    }

    public static Builder builder() {
        return new AutoValue_ExecutionState.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return ExecutionState.builder();
        }

        @JsonProperty(value="global_override")
        public abstract Builder setGlobalOverride(ExecutionStateGlobalOverride var1);

        public abstract ExecutionStateGlobalOverride.Builder globalOverrideBuilder();

        @JsonProperty
        public abstract ImmutableMap.Builder<String, ExecutionStateGlobalOverride> queriesBuilder();

        public abstract ImmutableMap.Builder<String, Parameter.Binding> parameterBindingsBuilder();

        @JsonProperty(value="parameter_bindings")
        public Builder withParameterBindings(Map<String, Parameter.Binding> values) {
            values.forEach((s, o) -> this.parameterBindingsBuilder().put(s, o));
            return this;
        }

        public abstract ImmutableMap.Builder<String, Object> additionalParametersBuilder();

        @JsonProperty(value="additional_parameters")
        public Builder withAdditionalParameters(Map<String, Object> values) {
            values.forEach((s, o) -> this.additionalParametersBuilder().put(s, o));
            return this;
        }

        @JsonAnySetter
        public Builder addAdditionalParameter(String key, Object value) {
            this.additionalParametersBuilder().put((Object)key, value);
            return this;
        }

        public abstract ExecutionState build();
    }
}

