/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.TabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.request.AggregationRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.Metadata;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationTabularResponseCreator
implements TabularResponseCreator {
    private static final Logger LOG = LoggerFactory.getLogger(AggregationTabularResponseCreator.class);

    public TabularResponse mapToResponse(AggregationRequestSpec searchRequestSpec, SearchJob searchJob) throws QueryFailedException {
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        QueryResult queryResult = searchJobDTO.results().get("scripting_api_temporary_query");
        if (queryResult != null) {
            this.throwErrorIfAnyAvailable(queryResult);
            SearchType.Result aggregationResult = queryResult.searchTypes().get("scripting_api_temporary_pivot");
            if (aggregationResult instanceof PivotResult) {
                PivotResult pivotResult = (PivotResult)aggregationResult;
                List<SeriesSpec> seriesSpecs = this.extractSeriesSpec(queryResult);
                return this.mapToResponse(searchRequestSpec, pivotResult, seriesSpecs);
            }
        }
        LOG.warn("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
        throw new QueryFailedException("Scripting API failed to obtain aggregation for input : " + searchRequestSpec);
    }

    private List<SeriesSpec> extractSeriesSpec(QueryResult queryResult) {
        return queryResult.query().searchTypes().stream().filter(t -> "scripting_api_temporary_pivot".equals(t.id())).findFirst().stream().filter(searchType -> searchType instanceof Pivot).map(pivot -> (Pivot)pivot).flatMap(pivot -> pivot.series().stream()).collect(Collectors.toList());
    }

    private TabularResponse mapToResponse(AggregationRequestSpec searchRequestSpec, PivotResult pivotResult, List<SeriesSpec> seriesSpec) {
        return new TabularResponse(searchRequestSpec.getSchema(), AggregationTabularResponseCreator.getDatarows(searchRequestSpec, pivotResult, seriesSpec), new Metadata(pivotResult.effectiveTimerange()));
    }

    private static List<List<Object>> getDatarows(AggregationRequestSpec searchRequestSpec, PivotResult pivotResult, List<SeriesSpec> seriesSpecs) {
        int numGroupings = searchRequestSpec.groupings().size();
        return pivotResult.rows().stream().map(pivRow -> {
            Stream groupings = Stream.concat(pivRow.key().stream(), Collections.nCopies(numGroupings - pivRow.key().size(), "-").stream());
            ImmutableList<PivotResult.Value> values = pivRow.values();
            Stream<Object> metrics = seriesSpecs.stream().map(s -> AggregationTabularResponseCreator.metricValue(s, values));
            return Stream.concat(groupings, metrics).collect(Collectors.toList());
        }).collect(Collectors.toList());
    }

    private static Object metricValue(SeriesSpec seriesSpec, ImmutableList<PivotResult.Value> values) {
        return values.stream().filter(value -> AggregationTabularResponseCreator.isMetricValue(seriesSpec, value)).findFirst().map(PivotResult.Value::value).orElse("-");
    }

    private static boolean isMetricValue(SeriesSpec metric, PivotResult.Value value) {
        return value.key().contains((Object)metric.literal());
    }
}

