/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.views;

import com.google.common.base.Preconditions;
import org.apache.commons.lang3.StringUtils;

public class ViewResolverDecoder {
    public static final String SEPARATOR = ":";
    private final String viewId;

    public ViewResolverDecoder(String viewId) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)viewId), (Object)"View ID cannot be blank.");
        this.viewId = viewId;
    }

    public boolean isResolverViewId() {
        return this.viewId.contains(SEPARATOR);
    }

    public String getResolverName() {
        String[] split = this.viewId.split(SEPARATOR);
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)"Cannot get resolver name for standard view ID.");
        return split[0];
    }

    public String getViewId() {
        String[] split = this.viewId.split(SEPARATOR);
        Preconditions.checkArgument((split.length == 2 ? 1 : 0) != 0, (Object)"Cannot get resolver ID for standard view ID.");
        return split[1];
    }
}

