/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.startpage;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.inject.Inject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.startpage.StartPageService;
import org.graylog.plugins.views.startpage.lastOpened.LastOpened;
import org.graylog.plugins.views.startpage.recentActivities.RecentActivity;
import org.graylog2.plugin.rest.PluginRestResource;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.shared.rest.resources.RestResource;

@Api(value="StartPage", tags={"cloud"})
@Path(value="/startpage")
@Produces(value={"application/json"})
@RequiresAuthentication
public class StartPageResource
extends RestResource
implements PluginRestResource {
    private final StartPageService service;

    @Inject
    public StartPageResource(StartPageService service) {
        this.service = service;
    }

    @GET
    @Path(value="/lastOpened")
    @ApiOperation(value="Get the Last Opened Items for the Start Page for the user")
    public PaginatedResponse<LastOpened> getLastOpened(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="5") int perPage, @Context SearchUser searchUser) {
        return this.service.findLastOpenedFor(searchUser, page, perPage);
    }

    @GET
    @Path(value="/recentActivity")
    @ApiOperation(value="Get Recent Activities for the Start Page for the user")
    public PaginatedResponse<RecentActivity> getRecentActivity(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="5") int perPage, @Context SearchUser searchUser) {
        return this.service.findRecentActivityFor(searchUser, page, perPage);
    }
}

