/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight;

import com.codahale.metrics.InstrumentedExecutorService;
import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractIdleService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import org.glassfish.grizzly.http.CompressionConfig;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.model.Resource;
import org.graylog2.bootstrap.preflight.PreflightRestResourcesBinding;
import org.graylog2.bootstrap.preflight.web.PreflightAuthFilter;
import org.graylog2.configuration.HttpConfiguration;
import org.graylog2.rest.MoreMediaTypes;
import org.graylog2.shared.rest.exceptionmappers.JacksonPropertyExceptionMapper;
import org.graylog2.shared.rest.exceptionmappers.JsonProcessingExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreflightJerseyService
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(PreflightJerseyService.class);
    private final HttpConfiguration configuration;
    private final PreflightAuthFilter preflightAuthFilter;
    private final Set<Class<?>> systemRestResources;
    private final ObjectMapper objectMapper;
    private final MetricRegistry metricRegistry;
    private HttpServer apiHttpServer = null;

    @Inject
    public PreflightJerseyService(HttpConfiguration configuration, PreflightAuthFilter preflightAuthFilter, @PreflightRestResourcesBinding Set<Class<?>> systemRestResources, ObjectMapper objectMapper, MetricRegistry metricRegistry) {
        this.configuration = Objects.requireNonNull(configuration, "configuration");
        this.preflightAuthFilter = Objects.requireNonNull(preflightAuthFilter, "preflightAuthFilter");
        this.systemRestResources = systemRestResources;
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "metricRegistry");
    }

    protected void startUp() throws Exception {
        System.setProperty("org.glassfish.grizzly.DEFAULT_MEMORY_MANAGER", "org.glassfish.grizzly.memory.HeapMemoryManager");
        this.startUpApi();
    }

    protected void shutDown() throws Exception {
        this.shutdownHttpServer(this.apiHttpServer, this.configuration.getHttpBindAddress());
    }

    private void shutdownHttpServer(HttpServer httpServer, HostAndPort bindAddress) {
        if (httpServer != null && httpServer.isStarted()) {
            LOG.info("Shutting down HTTP listener at <{}>", (Object)bindAddress);
            httpServer.shutdownNow();
        }
    }

    private void startUpApi() throws Exception {
        SSLEngineConfigurator sslEngineConfigurator = null;
        HostAndPort bindAddress = this.configuration.getHttpBindAddress();
        String contextPath = this.configuration.getHttpPublishUri().getPath();
        URI listenUri = new URI(this.configuration.getUriScheme(), null, bindAddress.getHost(), bindAddress.getPort(), Strings.isNullOrEmpty((String)contextPath) ? "/" : contextPath, null, null);
        this.apiHttpServer = this.setUp(listenUri, sslEngineConfigurator, this.configuration.getHttpThreadPoolSize(), this.configuration.getHttpSelectorRunnersCount(), this.configuration.getHttpMaxHeaderSize(), this.configuration.isHttpEnableGzip(), Set.of());
        this.apiHttpServer.start();
        LOG.info("Started preflight REST API at <{}>", (Object)this.configuration.getHttpBindAddress());
    }

    private ResourceConfig buildResourceConfig(Set<Resource> additionalResources) {
        ResourceConfig rc = new ResourceConfig().property("jersey.config.beanValidation.enableOutputValidationErrorEntity.server", (Object)true).property("jersey.config.server.wadl.disableWadl", (Object)true).property("jersey.config.server.mediaTypeMappings", this.mediaTypeMappings()).registerClasses(new Class[]{JacksonJaxbJsonProvider.class, JsonProcessingExceptionMapper.class, JsonMappingExceptionMapper.class, JacksonPropertyExceptionMapper.class}).register((Object)new ContextResolver<ObjectMapper>(){

            public ObjectMapper getContext(Class<?> type) {
                return PreflightJerseyService.this.objectMapper;
            }
        }).register(MultiPartFeature.class).registerClasses(this.systemRestResources).registerResources(additionalResources).register((Object)this.preflightAuthFilter);
        return rc;
    }

    private Map<String, MediaType> mediaTypeMappings() {
        return ImmutableMap.of((Object)"json", (Object)MediaType.APPLICATION_JSON_TYPE, (Object)"ndjson", (Object)MoreMediaTypes.APPLICATION_NDJSON_TYPE, (Object)"csv", (Object)MoreMediaTypes.TEXT_CSV_TYPE, (Object)"log", (Object)MoreMediaTypes.TEXT_PLAIN_TYPE);
    }

    private HttpServer setUp(URI listenUri, SSLEngineConfigurator sslEngineConfigurator, int threadPoolSize, int selectorRunnersCount, int maxHeaderSize, boolean enableGzip, Set<Resource> additionalResources) {
        ResourceConfig resourceConfig = this.buildResourceConfig(additionalResources);
        HttpServer httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)listenUri, (ResourceConfig)resourceConfig, (sslEngineConfigurator != null ? 1 : 0) != 0, (SSLEngineConfigurator)sslEngineConfigurator, (boolean)false);
        NetworkListener listener = httpServer.getListener("grizzly");
        listener.setMaxHttpHeaderSize(maxHeaderSize);
        ExecutorService workerThreadPoolExecutor = this.instrumentedExecutor("http-worker-executor", "http-worker-%d", threadPoolSize);
        listener.getTransport().setWorkerThreadPool(workerThreadPoolExecutor);
        listener.getTransport().setSelectorRunnersCount(selectorRunnersCount);
        if (enableGzip) {
            CompressionConfig compressionConfig = listener.getCompressionConfig();
            compressionConfig.setCompressionMode(CompressionConfig.CompressionMode.ON);
            compressionConfig.setCompressionMinSize(512);
        }
        return httpServer;
    }

    private ExecutorService instrumentedExecutor(String executorName, String threadNameFormat, int poolSize) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(threadNameFormat).setDaemon(true).build();
        return new InstrumentedExecutorService(Executors.newFixedThreadPool(poolSize, threadFactory), this.metricRegistry, MetricRegistry.name(PreflightJerseyService.class, (String[])new String[]{executorName}));
    }
}

