/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.bootstrap.preflight.web.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.bootstrap.preflight.web.resources.model.CA;
import org.graylog2.bootstrap.preflight.web.resources.model.CAType;
import org.graylog2.bootstrap.preflight.web.resources.model.CertParameters;
import org.graylog2.cluster.Node;
import org.graylog2.cluster.NodeService;

@Path(value="/api/")
@Produces(value={"application/json"})
public class PreflightResource {
    private final NodeService nodeService;
    private static CA currentCA = null;
    private static Map<String, CertParameters> dataNodeCertParameters = new HashMap<String, CertParameters>();

    @Inject
    public PreflightResource(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    @GET
    @Path(value="/data_nodes")
    public List<Node> listDataNodes() {
        Map<String, Node> activeDataNodes = this.nodeService.allActive(Node.Type.DATANODE);
        return new ArrayList<Node>(activeDataNodes.values());
    }

    @GET
    @Path(value="/ca")
    public CA get() {
        return currentCA;
    }

    @POST
    @Path(value="/ca/create")
    @NoAuditEvent(value="No Audit Event needed")
    public void createCA() {
        currentCA = new CA("generated CA", CAType.GENERATED);
    }

    @POST
    @Path(value="/ca/upload")
    @NoAuditEvent(value="No Audit Event needed")
    @Consumes(value={"application/json"})
    public void uploadCA() {
        currentCA = new CA("uploaded CA", CAType.UPLOADED);
    }

    @DELETE
    @Path(value="/startOver")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver() {
        currentCA = null;
        dataNodeCertParameters.clear();
    }

    @DELETE
    @Path(value="/startOver/{nodeID}")
    @NoAuditEvent(value="No Audit Event needed")
    public void startOver(@PathParam(value="nodeID") String nodeID) {
        dataNodeCertParameters.remove(nodeID);
    }

    @POST
    @Path(value="/generate")
    @NoAuditEvent(value="No Audit Event needed")
    public void generate() {
    }

    @POST
    @Path(value="/{nodeID}")
    @Consumes(value={"application/json"})
    @NoAuditEvent(value="No Audit Event needed")
    public void addParameters(@PathParam(value="nodeID") String nodeID, @NotNull CertParameters params) {
        dataNodeCertParameters.put(nodeID, params);
    }
}

