/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.graylog2.indexer.IndexMappingTemplate;
import org.graylog2.indexer.indexset.IndexSetConfig;

public abstract class IndexMapping
implements IndexMappingTemplate {
    public static final String TYPE_MESSAGE = "message";

    @Override
    public Map<String, Object> toTemplate(IndexSetConfig indexSetConfig, String indexPattern, int order) {
        return this.messageTemplate(indexPattern, indexSetConfig.indexAnalyzer(), order);
    }

    protected Map<String, Object> analyzerKeyword() {
        return ImmutableMap.of((Object)"analyzer_keyword", (Object)ImmutableMap.of((Object)"tokenizer", (Object)"keyword", (Object)"filter", (Object)"lowercase"));
    }

    public Map<String, Object> messageTemplate(String template, String analyzer, int order) {
        Map<String, Object> settings = Collections.singletonMap("analysis", Collections.singletonMap("analyzer", this.analyzerKeyword()));
        Map<String, Object> mappings = this.mapping(analyzer);
        return this.createTemplate(template, order, settings, mappings);
    }

    Map<String, Object> createTemplate(String template, int order, Map<String, Object> settings, Map<String, Object> mappings) {
        return ImmutableMap.of((Object)"template", (Object)template, (Object)"order", (Object)order, (Object)"settings", settings, (Object)"mappings", mappings);
    }

    protected Map<String, Object> mapping(String analyzer) {
        return ImmutableMap.of((Object)TYPE_MESSAGE, this.messageMapping(analyzer));
    }

    protected Map<String, Object> messageMapping(String analyzer) {
        return ImmutableMap.of((Object)"properties", this.fieldProperties(analyzer), (Object)"dynamic_templates", this.dynamicTemplate(), (Object)"_source", this.enabled());
    }

    private Map<String, Map<String, Object>> internalFieldsMapping() {
        return ImmutableMap.of((Object)"internal_fields", (Object)ImmutableMap.of((Object)"match", (Object)"gl2_*", (Object)"match_mapping_type", (Object)"string", (Object)"mapping", this.notAnalyzedString()));
    }

    protected List<Map<String, Map<String, Object>>> dynamicTemplate() {
        Map<String, Map<String, Object>> templateInternal = this.internalFieldsMapping();
        ImmutableMap templateAll = ImmutableMap.of((Object)"store_generic", this.dynamicStrings());
        return ImmutableList.of(templateInternal, (Object)templateAll);
    }

    abstract Map<String, Object> dynamicStrings();

    protected Map<String, Map<String, Object>> fieldProperties(String analyzer) {
        return ImmutableMap.builder().put((Object)TYPE_MESSAGE, this.analyzedString(analyzer, false)).put((Object)"full_message", this.analyzedString(analyzer, false)).put((Object)"timestamp", this.typeTimeWithMillis()).put((Object)"gl2_accounted_message_size", this.typeLong()).put((Object)"gl2_receive_timestamp", this.typeTimeWithMillis()).put((Object)"gl2_processing_timestamp", this.typeTimeWithMillis()).put((Object)"gl2_message_id", this.notAnalyzedString()).put((Object)"source", this.analyzedString("analyzer_keyword", true)).put((Object)"streams", this.notAnalyzedString()).build();
    }

    Map<String, Object> notAnalyzedString() {
        return ImmutableMap.of((Object)"type", (Object)"keyword");
    }

    Map<String, Object> analyzedString(String analyzer, boolean fieldData) {
        return ImmutableMap.of((Object)"type", (Object)"text", (Object)"analyzer", (Object)analyzer, (Object)"fielddata", (Object)fieldData);
    }

    protected Map<String, Object> typeTimeWithMillis() {
        return ImmutableMap.of((Object)"type", (Object)"date", (Object)"format", (Object)this.dateFormat());
    }

    protected Map<String, Object> typeLong() {
        return ImmutableMap.of((Object)"type", (Object)"long");
    }

    private Map<String, Boolean> enabled() {
        return ImmutableMap.of((Object)"enabled", (Object)true);
    }

    protected String dateFormat() {
        return "8yyyy-MM-dd HH:mm:ss.SSS";
    }
}

