/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.fieldtypes;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSet;
import org.graylog2.indexer.fieldtypes.FieldTypeDTO;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePollerAdapter;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesDTO;
import org.graylog2.indexer.indices.Indices;

public class IndexFieldTypePoller {
    private final Indices indices;
    private final Timer pollTimer;
    private final IndexFieldTypePollerAdapter indexFieldTypePollerAdapter;
    private final boolean maintainsStreamBasedFieldLists;

    @Inject
    public IndexFieldTypePoller(Indices indices, MetricRegistry metricRegistry, IndexFieldTypePollerAdapter indexFieldTypePollerAdapter) {
        this.indices = indices;
        this.pollTimer = metricRegistry.timer(MetricRegistry.name(this.getClass(), (String[])new String[]{"indexPollTime"}));
        this.indexFieldTypePollerAdapter = indexFieldTypePollerAdapter;
        this.maintainsStreamBasedFieldLists = indexFieldTypePollerAdapter.maintainsStreamBasedFieldLists();
    }

    public Set<IndexFieldTypesDTO> poll(IndexSet indexSet, Set<IndexFieldTypesDTO> existingIndexTypes) {
        String activeWriteIndex = indexSet.getActiveWriteIndex();
        Set existingIndexNames = existingIndexTypes.stream().map(IndexFieldTypesDTO::indexName).collect(Collectors.toSet());
        return this.indices.getIndices(indexSet, "open").stream().filter(indexName -> indexName.equals(activeWriteIndex) || !existingIndexNames.contains(indexName) || this.maintainsStreamBasedFieldLists && this.missesStreamData((Collection<IndexFieldTypesDTO>)existingIndexTypes, (String)indexName)).map(indexName -> this.pollIndex((String)indexName, indexSet.getConfig().id())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private boolean missesStreamData(Collection<IndexFieldTypesDTO> existingIndexTypes, String indexName) {
        return existingIndexTypes.stream().filter(x -> x.indexName().equals(indexName)).anyMatch(x -> !x.hasStreamData());
    }

    public Optional<IndexFieldTypesDTO> pollIndex(String indexName, String indexSetId) {
        Optional<Set<FieldTypeDTO>> optionalFields = this.indexFieldTypePollerAdapter.pollIndex(indexName, this.pollTimer);
        return optionalFields.map(fields -> IndexFieldTypesDTO.builder().indexSetId(indexSetId).indexName(indexName).fields((Set<FieldTypeDTO>)fields).hasStreamData(this.maintainsStreamBasedFieldLists).build());
    }
}

