/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.inputs.encryption;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.graylog2.plugin.configuration.fields.ConfigurationField;
import org.graylog2.plugin.inputs.MessageInput;
import org.graylog2.security.encryption.EncryptedValue;

public class EncryptedInputConfigs {
    private EncryptedInputConfigs() {
    }

    public static Map<String, Object> merge(Map<String, Object> orig, Map<String, Object> update) {
        HashMap<String, Object> merged = new HashMap<String, Object>(orig);
        update.forEach((k, v) -> {
            Object patt1767$temp = orig.get(k);
            if (patt1767$temp instanceof EncryptedValue) {
                EncryptedValue origValue = (EncryptedValue)patt1767$temp;
                if (v instanceof EncryptedValue) {
                    EncryptedValue newValue = (EncryptedValue)v;
                    merged.put((String)k, EncryptedInputConfigs.mergeEncryptedValues(origValue, newValue));
                    return;
                }
            }
            merged.put((String)k, v);
        });
        return merged;
    }

    public static Set<String> getEncryptedFields(@Nonnull MessageInput.Config messageInputConfig) {
        return messageInputConfig.combinedRequestedConfiguration().getFields().values().stream().filter(ConfigurationField::isEncrypted).map(ConfigurationField::getName).collect(Collectors.toSet());
    }

    private static EncryptedValue mergeEncryptedValues(EncryptedValue origValue, EncryptedValue newValue) {
        if (newValue.isKeepValue()) {
            return origValue;
        }
        if (newValue.isDeleteValue()) {
            return EncryptedValue.createUnset();
        }
        return newValue;
    }
}

