/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import java.time.ZonedDateTime;
import javax.inject.Inject;
import org.graylog2.configuration.ElasticsearchConfiguration;
import org.graylog2.indexer.management.IndexManagementConfig;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategy;
import org.graylog2.indexer.retention.strategies.ClosingRetentionStrategyConfig;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategy;
import org.graylog2.indexer.retention.strategies.DeletionRetentionStrategyConfig;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategy;
import org.graylog2.indexer.rotation.strategies.MessageCountRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.SizeBasedRotationStrategyConfig;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategy;
import org.graylog2.indexer.rotation.strategies.TimeBasedRotationStrategyConfig;
import org.graylog2.indexer.searches.SearchesClusterConfig;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20151210140600_ElasticsearchConfigMigration
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20151210140600_ElasticsearchConfigMigration.class);
    private final ClusterConfigService clusterConfigService;
    private final ElasticsearchConfiguration elasticsearchConfiguration;

    @Inject
    public V20151210140600_ElasticsearchConfigMigration(ClusterConfigService clusterConfigService, ElasticsearchConfiguration elasticsearchConfiguration) {
        this.clusterConfigService = clusterConfigService;
        this.elasticsearchConfiguration = elasticsearchConfiguration;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2015-12-10T14:06:00Z");
    }

    @Override
    public void upgrade() {
        SearchesClusterConfig searchesClusterConfig;
        IndexManagementConfig indexManagementConfig;
        MessageCountRotationStrategyConfig messageCountRotationStrategyConfig = this.clusterConfigService.get(MessageCountRotationStrategyConfig.class);
        SizeBasedRotationStrategyConfig sizeBasedRotationStrategyConfig = this.clusterConfigService.get(SizeBasedRotationStrategyConfig.class);
        TimeBasedRotationStrategyConfig timeBasedRotationStrategyConfig = this.clusterConfigService.get(TimeBasedRotationStrategyConfig.class);
        if (messageCountRotationStrategyConfig == null) {
            MessageCountRotationStrategyConfig countConfig = MessageCountRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxDocsPerIndex());
            this.clusterConfigService.write(countConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_docs_per_index", (Object)countConfig);
        }
        if (sizeBasedRotationStrategyConfig == null) {
            SizeBasedRotationStrategyConfig sizeConfig = SizeBasedRotationStrategyConfig.create(this.elasticsearchConfiguration.getMaxSizePerIndex());
            this.clusterConfigService.write(sizeConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_size_per_index", (Object)sizeConfig);
        }
        if (timeBasedRotationStrategyConfig == null) {
            TimeBasedRotationStrategyConfig timeConfig = TimeBasedRotationStrategyConfig.builder().rotationPeriod(this.elasticsearchConfiguration.getMaxTimePerIndex()).maxRotationPeriod(this.elasticsearchConfiguration.getMaxWriteIndexAge()).rotateEmptyIndexSet(this.elasticsearchConfiguration.isRotateEmptyIndex()).build();
            this.clusterConfigService.write(timeConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_time_per_index", (Object)timeConfig);
        }
        ClosingRetentionStrategyConfig closingRetentionStrategyConfig = this.clusterConfigService.get(ClosingRetentionStrategyConfig.class);
        DeletionRetentionStrategyConfig deletionRetentionStrategyConfig = this.clusterConfigService.get(DeletionRetentionStrategyConfig.class);
        if (closingRetentionStrategyConfig == null) {
            ClosingRetentionStrategyConfig closingConfig = ClosingRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
            this.clusterConfigService.write(closingConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)closingConfig);
        }
        if (deletionRetentionStrategyConfig == null) {
            DeletionRetentionStrategyConfig deletionConfig = DeletionRetentionStrategyConfig.create(this.elasticsearchConfiguration.getMaxNumberOfIndices());
            this.clusterConfigService.write(deletionConfig);
            LOG.info("Migrated \"{}\" setting: {}", (Object)"elasticsearch_max_number_of_indices", (Object)deletionConfig);
        }
        if ((indexManagementConfig = this.clusterConfigService.get(IndexManagementConfig.class)) == null) {
            IndexManagementConfig config = IndexManagementConfig.create((switch (this.elasticsearchConfiguration.getRotationStrategy()) {
                case "size" -> SizeBasedRotationStrategy.class;
                case "time" -> TimeBasedRotationStrategy.class;
                case "count" -> MessageCountRotationStrategy.class;
                default -> {
                    LOG.warn("Unknown retention strategy \"{}\"", (Object)this.elasticsearchConfiguration.getRotationStrategy());
                    yield MessageCountRotationStrategy.class;
                }
            }).getCanonicalName(), (switch (this.elasticsearchConfiguration.getRetentionStrategy()) {
                case "close" -> ClosingRetentionStrategy.class;
                case "delete" -> DeletionRetentionStrategy.class;
                default -> {
                    LOG.warn("Unknown retention strategy \"{}\"", (Object)this.elasticsearchConfiguration.getRetentionStrategy());
                    yield DeletionRetentionStrategy.class;
                }
            }).getCanonicalName());
            this.clusterConfigService.write(config);
            LOG.info("Migrated \"{}\" and \"{}\" setting: {}", new Object[]{"rotation_strategy", "retention_strategy", config});
        }
        if ((searchesClusterConfig = this.clusterConfigService.get(SearchesClusterConfig.class)) == null) {
            SearchesClusterConfig config = SearchesClusterConfig.createDefault();
            LOG.info("Creating searches cluster config: {}", (Object)config);
            this.clusterConfigService.write(config);
        }
    }
}

