/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.migrations;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import one.util.streamex.EntryStream;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.graylog2.database.MongoConnection;
import org.graylog2.migrations.Migration;
import org.graylog2.migrations.V20230113095300_MigrateGlobalPivotLimitsToGroupingsInViews;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20230113095301_MigrateGlobalPivotLimitsToGroupingsInSearches
extends Migration {
    private static final int DEFAULT_LIMIT = 15;
    private static final Logger LOG = LoggerFactory.getLogger(V20230113095300_MigrateGlobalPivotLimitsToGroupingsInViews.class);
    private final ClusterConfigService clusterConfigService;
    private final MongoCollection<Document> searches;
    private final Document matchValuePivots = this.doc("pivot.type", "values");

    @Inject
    public V20230113095301_MigrateGlobalPivotLimitsToGroupingsInSearches(MongoConnection mongoConnection, ClusterConfigService clusterConfigService) {
        this.clusterConfigService = clusterConfigService;
        this.searches = mongoConnection.getMongoDatabase().getCollection("searches");
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2023-01-13T09:53:01Z");
    }

    @Override
    public void upgrade() {
        if (this.clusterConfigService.get(MigrationCompleted.class) != null) {
            LOG.debug("Migration already completed!");
            return;
        }
        List pivotLimitMigrations = StreamSupport.stream(this.searches.find().spliterator(), false).flatMap(document -> {
            String searchId = ((ObjectId)document.get((Object)"_id", ObjectId.class)).toHexString();
            List queries = (List)document.get((Object)"queries", Collections.emptyList());
            return EntryStream.of((List)queries).flatMap(entry -> {
                Integer queryIndex = (Integer)entry.getKey();
                List searchTypes = (List)((Document)entry.getValue()).get((Object)"search_types", Collections.emptyList());
                return ((EntryStream)EntryStream.of((List)searchTypes).filter(searchType -> "pivot".equals(((Document)searchType.getValue()).getString((Object)"type")))).flatMap(searchTypeEntry -> {
                    Document searchType = (Document)searchTypeEntry.getValue();
                    Integer searchTypeIndex = (Integer)searchTypeEntry.getKey();
                    boolean hasRowLimit = searchType.containsKey((Object)"row_limit");
                    boolean hasColumnLimit = searchType.containsKey((Object)"column_limit");
                    Optional<Integer> rowLimit = Optional.ofNullable(searchType.getInteger((Object)"row_limit"));
                    Optional<Integer> columnLimit = Optional.ofNullable(searchType.getInteger((Object)"column_limit"));
                    if (searchTypeIndex != null && (hasRowLimit || hasColumnLimit)) {
                        return Stream.of(new SearchPivotLimitMigration(searchId, queryIndex, searchTypeIndex, rowLimit, columnLimit));
                    }
                    return Stream.empty();
                });
            });
        }).collect(Collectors.toList());
        List operations = pivotLimitMigrations.stream().flatMap(pivotMigration -> {
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.add(this.updateSearch(pivotMigration.searchId(), this.doc("$unset", this.doc(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".row_limit", 1))));
            builder.add(this.updateSearch(pivotMigration.searchId(), this.doc("$set", this.doc(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".row_groups.$[pivot].limit", pivotMigration.rowLimit.orElse(15))), (Bson)this.matchValuePivots));
            builder.add(this.updateSearch(pivotMigration.searchId(), this.doc("$unset", this.doc(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".column_limit", 1))));
            builder.add(this.updateSearch(pivotMigration.searchId(), this.doc("$set", this.doc(this.pivotPath((SearchPivotLimitMigration)pivotMigration) + ".column_groups.$[pivot].limit", pivotMigration.columnLimit.orElse(15))), (Bson)this.matchValuePivots));
            return builder.build().stream();
        }).collect(Collectors.toList());
        if (!operations.isEmpty()) {
            LOG.debug("Updating {} search types ...", (Object)pivotLimitMigrations.size());
            this.searches.bulkWrite(operations);
        }
        this.clusterConfigService.write(new MigrationCompleted(pivotLimitMigrations.size()));
    }

    private String pivotPath(SearchPivotLimitMigration pivotMigration) {
        return "queries." + pivotMigration.queryIndex() + ".search_types." + pivotMigration.searchTypeIndex();
    }

    private WriteModel<Document> updateSearch(String searchId, Document update, List<Bson> arrayFilters) {
        return new UpdateOneModel((Bson)this.doc("_id", new ObjectId(searchId)), (Bson)update, new UpdateOptions().upsert(false).arrayFilters(arrayFilters));
    }

    private WriteModel<Document> updateSearch(String searchId, Document update, Bson arrayFilter) {
        return this.updateSearch(searchId, update, Collections.singletonList(arrayFilter));
    }

    private WriteModel<Document> updateSearch(String searchId, Document update) {
        return this.updateSearch(searchId, update, (List<Bson>)null);
    }

    private Document doc(String key, Object value) {
        return new Document(key, value);
    }

    public record MigrationCompleted(@JsonProperty(value="migrated_search_types") Integer migratedSearchTypes) {
    }

    public record SearchPivotLimitMigration(String searchId, Integer queryIndex, Integer searchTypeIndex, Optional<Integer> rowLimit, Optional<Integer> columnLimit) {
    }
}

