/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.notifications;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog.events.processor.DBEventDefinitionService;
import org.graylog.events.processor.EventDefinitionDto;
import org.graylog.events.processor.EventProcessorEngine;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.processor.systemnotification.SystemNotificationEventProcessorParameters;
import org.graylog.events.processor.systemnotification.SystemNotificationRenderService;
import org.graylog2.audit.AuditActor;
import org.graylog2.audit.AuditEventSender;
import org.graylog2.cluster.Node;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PersistedServiceImpl;
import org.graylog2.notifications.Notification;
import org.graylog2.notifications.NotificationImpl;
import org.graylog2.notifications.NotificationService;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.plugin.system.NodeId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class NotificationServiceImpl
extends PersistedServiceImpl
implements NotificationService {
    private static final Logger LOG = LoggerFactory.getLogger(NotificationServiceImpl.class);
    private final NodeId nodeId;
    private final AuditEventSender auditEventSender;
    private final EventProcessorEngine eventProcessorEngine;
    private final DBEventDefinitionService dbEventDefinitionService;
    private final SystemNotificationRenderService systemNotificationRenderService;

    @Inject
    public NotificationServiceImpl(NodeId nodeId, MongoConnection mongoConnection, AuditEventSender auditEventSender, EventProcessorEngine eventProcessorEngine, DBEventDefinitionService dbEventDefinitionService, SystemNotificationRenderService systemNotificationRenderService) {
        super(mongoConnection);
        this.nodeId = (NodeId)Preconditions.checkNotNull((Object)nodeId);
        this.auditEventSender = auditEventSender;
        this.eventProcessorEngine = eventProcessorEngine;
        this.dbEventDefinitionService = dbEventDefinitionService;
        this.systemNotificationRenderService = systemNotificationRenderService;
        this.collection(NotificationImpl.class).createIndex("type");
    }

    @Override
    public Notification build() {
        return new NotificationImpl();
    }

    @Override
    public Notification buildNow() {
        Notification notification = this.build();
        notification.addTimestamp(Tools.nowUTC());
        return notification;
    }

    @Override
    public boolean fixed(Notification.Type type) {
        return this.fixed(type, (Node)null);
    }

    @Override
    public boolean fixed(Notification.Type type, String key) {
        boolean removed;
        BasicDBObject qry = NotificationServiceImpl.typeAndKeyQuery(type, key);
        boolean bl = removed = this.destroyAll(NotificationImpl.class, (DBObject)qry) > 0;
        if (removed) {
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:delete", Map.of("notification_type", type.getDeclaringClass().getCanonicalName()));
        }
        return removed;
    }

    @Override
    public boolean fixed(Notification notification) {
        return this.fixed(notification.getType(), (Node)null);
    }

    @Override
    public boolean fixed(Notification.Type type, Node node) {
        boolean removed;
        BasicDBObject qry = new BasicDBObject();
        qry.put((Object)"type", (Object)type.toString().toLowerCase(Locale.ENGLISH));
        if (node != null) {
            qry.put((Object)"node_id", (Object)node.getNodeId());
        }
        boolean bl = removed = this.destroyAll(NotificationImpl.class, (DBObject)qry) > 0;
        if (removed) {
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:delete", Collections.singletonMap("notification_type", type.getDeclaringClass().getCanonicalName()));
        }
        return removed;
    }

    @Override
    public boolean isFirst(Notification.Type type) {
        return this.isFirst(type, null);
    }

    private boolean isFirst(Notification.Type type, @Nullable String key) {
        BasicDBObject query = NotificationServiceImpl.typeAndKeyQuery(type, key);
        return this.findOne(NotificationImpl.class, (DBObject)query) == null;
    }

    @Override
    public List<Notification> all() {
        List<DBObject> dbObjects = this.query(NotificationImpl.class, (DBObject)new BasicDBObject(), (DBObject)new BasicDBObject("timestamp", (Object)-1));
        ArrayList notifications = Lists.newArrayListWithCapacity((int)dbObjects.size());
        for (DBObject obj : dbObjects) {
            try {
                notifications.add(new NotificationImpl(new ObjectId(obj.get("_id").toString()), obj.toMap()));
            }
            catch (IllegalArgumentException e) {
                LOG.warn("There is a notification type we can't handle: [{}]", obj.get("type"));
            }
        }
        return notifications;
    }

    @Override
    public Optional<Notification> getByTypeAndKey(Notification.Type type, String key) {
        DBObject dbObject = this.findOne(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, key));
        if (dbObject != null) {
            return Optional.of(new NotificationImpl(new ObjectId(dbObject.get("_id").toString()), dbObject.toMap()));
        }
        return Optional.empty();
    }

    @Override
    public boolean publishIfFirst(Notification notification) {
        if (notification.getNodeId() == null) {
            notification.addNode(this.nodeId.getNodeId());
        }
        if (notification.getTimestamp() == null) {
            notification.addTimestamp(Tools.nowUTC());
        }
        if (!this.isFirst(notification.getType(), notification.getKey())) {
            return false;
        }
        try {
            this.save(notification);
            this.auditEventSender.success(AuditActor.system(this.nodeId), "server:system_notification:create", notification.asMap());
            this.createSystemEvent(notification);
        }
        catch (ValidationException e) {
            LOG.error("Validating user warning failed.", (Throwable)e);
            this.auditEventSender.failure(AuditActor.system(this.nodeId), "server:system_notification:create", notification.asMap());
            return false;
        }
        catch (EventProcessorException processorException) {
            LOG.error("Failed to create event for system notification {}", (Object)notification.getType().toString(), (Object)processorException);
            return false;
        }
        return true;
    }

    private void createSystemEvent(Notification notification) throws EventProcessorException {
        EventDefinitionDto systemEventDefinition = (EventDefinitionDto)this.dbEventDefinitionService.getSystemEventDefinitions().stream().findFirst().orElseThrow(() -> new IllegalStateException("System notification event definition not found"));
        try {
            SystemNotificationRenderService.RenderResponse renderResponse = this.systemNotificationRenderService.render(notification);
            notification.addDetail("message_details", renderResponse.description);
            SystemNotificationEventProcessorParameters parameters = SystemNotificationEventProcessorParameters.builder().notificationType(notification.getType()).notificationMessage(renderResponse.title).notificationDetails(notification.getDetails()).timestamp(notification.getTimestamp()).build();
            this.eventProcessorEngine.execute(systemEventDefinition.id(), parameters);
        }
        catch (Exception e) {
            LOG.warn("Cannot render system event", (Throwable)e);
        }
    }

    @Override
    public int destroyAllByType(Notification.Type type) {
        return this.destroyAll(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, null));
    }

    @Override
    public int destroyAllByTypeAndKey(Notification.Type type, @Nullable String key) {
        return this.destroyAll(NotificationImpl.class, (DBObject)NotificationServiceImpl.typeAndKeyQuery(type, key));
    }

    private static BasicDBObject typeAndKeyQuery(Notification.Type type, @Nullable String key) {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"type", (Object)type.toString().toLowerCase(Locale.ENGLISH));
        if (key != null) {
            query.put((Object)"key", (Object)key);
        }
        return query;
    }
}

