/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.plugin.inputs.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketInformationDumper
extends SimpleChannelInboundHandler<ByteBuf> {
    private static final Logger LOG = LoggerFactory.getLogger(PacketInformationDumper.class);
    private final Logger sourceInputLog;
    private final String sourceInputName;
    private final String sourceInputId;

    public PacketInformationDumper(MessageInput sourceInput) {
        this.sourceInputName = sourceInput.getName();
        this.sourceInputId = sourceInput.getId();
        this.sourceInputLog = LoggerFactory.getLogger((String)(PacketInformationDumper.class.getCanonicalName() + "." + this.sourceInputId));
        LOG.debug("Set {} to TRACE for network packet metadata dumps of input {}", (Object)this.sourceInputLog.getName(), (Object)sourceInput.toIdentifier());
    }

    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        if (this.sourceInputLog.isTraceEnabled()) {
            this.sourceInputLog.trace("Recv network data: {} bytes via input '{}' <{}> from remote address {}", new Object[]{msg.readableBytes(), this.sourceInputName, this.sourceInputId, ctx.channel().remoteAddress()});
        }
    }
}

