/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.system;

import com.codahale.metrics.annotation.Timed;
import com.google.common.collect.ImmutableMap;
import io.krakens.grok.api.exception.GrokException;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.shiro.authz.annotation.RequiresAuthentication;
import org.graylog2.audit.jersey.AuditEvent;
import org.graylog2.audit.jersey.NoAuditEvent;
import org.graylog2.database.PaginatedList;
import org.graylog2.grok.GrokPattern;
import org.graylog2.grok.GrokPatternService;
import org.graylog2.grok.PaginatedGrokPatternService;
import org.graylog2.plugin.database.ValidationException;
import org.graylog2.rest.models.PaginatedResponse;
import org.graylog2.rest.models.system.grokpattern.requests.GrokPatternTestRequest;
import org.graylog2.rest.models.system.responses.GrokPatternList;
import org.graylog2.search.SearchQuery;
import org.graylog2.search.SearchQueryField;
import org.graylog2.search.SearchQueryParser;
import org.graylog2.shared.rest.resources.RestResource;

@RequiresAuthentication
@Path(value="/system/grok")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="System/Grok", description="Manage grok patterns", tags={"cloud"})
public class GrokResource
extends RestResource {
    private static final Pattern GROK_LINE_PATTERN = Pattern.compile("^(\\w+)[ \t]+(.*)$");
    private static final ImmutableMap<String, SearchQueryField> SEARCH_FIELD_MAPPING = ImmutableMap.builder().put((Object)"name", (Object)SearchQueryField.create("name")).put((Object)"pattern", (Object)SearchQueryField.create("pattern")).build();
    private final GrokPatternService grokPatternService;
    private final SearchQueryParser searchQueryParser;
    private final PaginatedGrokPatternService paginatedGrokPatternService;

    @Inject
    public GrokResource(GrokPatternService grokPatternService, PaginatedGrokPatternService paginatedGrokPatternService) {
        this.paginatedGrokPatternService = paginatedGrokPatternService;
        this.grokPatternService = grokPatternService;
        this.searchQueryParser = new SearchQueryParser("name", (Map<String, SearchQueryField>)SEARCH_FIELD_MAPPING);
    }

    @GET
    @Timed
    @Deprecated
    @ApiOperation(value="Get all existing grok patterns")
    public GrokPatternList listGrokPatterns() {
        this.checkPermission("inputs:read");
        return GrokPatternList.create(this.grokPatternService.loadAll());
    }

    @GET
    @Timed
    @Path(value="/paginated")
    @ApiOperation(value="Get existing grok patterns paged")
    @Produces(value={"application/json"})
    public PaginatedResponse<GrokPattern> getPage(@ApiParam(name="page") @QueryParam(value="page") @DefaultValue(value="1") int page, @ApiParam(name="per_page") @QueryParam(value="per_page") @DefaultValue(value="50") int perPage, @ApiParam(name="query") @QueryParam(value="query") @DefaultValue(value="") String query, @ApiParam(name="sort", value="The field to sort the result on", required=true, allowableValues="title,description,id") @DefaultValue(value="name") @QueryParam(value="sort") String sort, @ApiParam(name="order", value="The sort direction", allowableValues="asc, desc") @DefaultValue(value="asc") @QueryParam(value="order") String order) {
        SearchQuery searchQuery;
        this.checkPermission("inputs:read");
        try {
            searchQuery = this.searchQueryParser.parse(query);
        }
        catch (IllegalArgumentException e) {
            throw new BadRequestException("Invalid argument in search query: " + e.getMessage());
        }
        PaginatedList<GrokPattern> result = this.paginatedGrokPatternService.findPaginated(searchQuery, page, perPage, sort, order);
        return PaginatedResponse.create("patterns", result);
    }

    @GET
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Get the existing grok pattern")
    public GrokPattern listPattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:read");
        return this.grokPatternService.load(patternId);
    }

    @POST
    @Timed
    @Path(value="/test")
    @NoAuditEvent(value="Only used to test pattern.")
    @ApiOperation(value="Test pattern with sample data")
    public Response testPattern(@ApiParam(name="pattern", required=true) GrokPatternTestRequest request) {
        Map<String, Object> result;
        try {
            result = this.grokPatternService.match(request.grokPattern(), request.sampleData());
        }
        catch (GrokException | IllegalArgumentException e) {
            ImmutableMap error = ImmutableMap.of((Object)"message", (Object)e.getMessage());
            throw new BadRequestException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)error).build());
        }
        return Response.ok(result).build();
    }

    @POST
    @Timed
    @ApiOperation(value="Add a new named pattern", response=GrokPattern.class)
    @AuditEvent(type="server:grok_pattern:create")
    public Response createPattern(@ApiParam(name="pattern", required=true) @Valid @NotNull GrokPattern pattern) throws ValidationException {
        this.checkPermission("inputs:create");
        GrokPattern newPattern = this.grokPatternService.save(pattern.toBuilder().id(null).build());
        URI patternUri = this.getUriBuilderToSelf().path(GrokResource.class, "listPattern").build(new Object[]{newPattern.id()});
        return Response.created((URI)patternUri).entity((Object)newPattern).build();
    }

    @PUT
    @Timed
    @ApiOperation(value="Add a list of new patterns")
    @AuditEvent(type="server:grok_pattern_import:create")
    public Response bulkUpdatePatterns(@ApiParam(name="patterns", required=true) @NotNull GrokPatternList patternList, @Deprecated @QueryParam(value="replace") @DefaultValue(value="false") boolean deprecatedDropAllExisting, @ApiParam(name="import-strategy", value="Strategy to apply when importing.") @QueryParam(value="import-strategy") GrokPatternService.ImportStrategy importStrategy) throws ValidationException {
        this.checkPermission("inputs:create");
        try {
            if (!this.grokPatternService.validateAll(patternList.patterns())) {
                throw new ValidationException("Invalid pattern contained. Did not save any patterns.");
            }
        }
        catch (GrokException | IllegalArgumentException e) {
            throw new ValidationException("Invalid pattern. Did not save any patterns\n" + e.getMessage());
        }
        GrokPatternService.ImportStrategy resolvedStrategy = importStrategy != null ? importStrategy : (deprecatedDropAllExisting ? GrokPatternService.ImportStrategy.DROP_ALL_EXISTING : GrokPatternService.ImportStrategy.ABORT_ON_CONFLICT);
        this.grokPatternService.saveAll(patternList.patterns(), resolvedStrategy);
        return Response.accepted().build();
    }

    @POST
    @Consumes(value={"text/plain"})
    @Timed
    @ApiOperation(value="Add a list of new patterns")
    @AuditEvent(type="server:grok_pattern_import:create")
    public Response bulkUpdatePatternsFromTextFile(@ApiParam(name="patterns", required=true) @NotNull InputStream patternsFile, @Deprecated @QueryParam(value="replace") @DefaultValue(value="false") boolean deprecatedDropAllExisting, @ApiParam(name="import-strategy", value="Strategy to apply when importing.") @QueryParam(value="import-strategy") GrokPatternService.ImportStrategy importStrategy) throws ValidationException, IOException {
        this.checkPermission("inputs:create");
        List<GrokPattern> grokPatterns = this.readGrokPatterns(patternsFile);
        if (!grokPatterns.isEmpty()) {
            try {
                if (!this.grokPatternService.validateAll(grokPatterns)) {
                    throw new ValidationException("Invalid pattern contained. Did not save any patterns.");
                }
            }
            catch (GrokException | IllegalArgumentException e) {
                throw new ValidationException("Invalid pattern. Did not save any patterns\n" + e.getMessage());
            }
            GrokPatternService.ImportStrategy resolvedStrategy = importStrategy != null ? importStrategy : (deprecatedDropAllExisting ? GrokPatternService.ImportStrategy.DROP_ALL_EXISTING : GrokPatternService.ImportStrategy.ABORT_ON_CONFLICT);
            this.grokPatternService.saveAll(grokPatterns, resolvedStrategy);
        }
        return Response.accepted().build();
    }

    private List<GrokPattern> readGrokPatterns(InputStream patternList) throws IOException {
        try (InputStreamReader inputStreamReader = new InputStreamReader(patternList, StandardCharsets.UTF_8);){
            List<GrokPattern> list;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                list = bufferedReader.lines().map(String::trim).filter(s -> !s.startsWith("#") && !s.isEmpty()).map(GROK_LINE_PATTERN::matcher).filter(Matcher::matches).map(matcher -> GrokPattern.create(matcher.group(1), matcher.group(2))).collect(Collectors.toList());
            }
            return list;
        }
    }

    @PUT
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Update an existing pattern")
    @AuditEvent(type="server:grok_pattern:update")
    public GrokPattern updatePattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId, @ApiParam(name="pattern", required=true) GrokPattern pattern) throws ValidationException {
        this.checkPermission("inputs:edit");
        GrokPattern grokPattern = GrokPattern.builder().id(patternId).name(pattern.name()).pattern(pattern.pattern()).build();
        return this.grokPatternService.update(grokPattern);
    }

    @DELETE
    @Timed
    @Path(value="/{patternId}")
    @ApiOperation(value="Remove an existing pattern by id")
    @AuditEvent(type="server:grok_pattern:delete")
    public void removePattern(@ApiParam(name="patternId", required=true) @PathParam(value="patternId") String patternId) throws org.graylog2.database.NotFoundException {
        this.checkPermission("inputs:edit");
        this.grokPatternService.load(patternId);
        if (this.grokPatternService.delete(patternId) == 0) {
            throw new NotFoundException("Couldn't remove Grok pattern with ID " + patternId);
        }
    }
}

