/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.streams;

import com.google.common.collect.ImmutableList;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Field;
import com.mongodb.client.model.Variable;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.graylog2.streams.StreamDTO;
import org.mongojack.DBQuery;

public class PaginatedStreamService
extends PaginatedDbService<StreamDTO> {
    private static final String COLLECTION_NAME = "streams";
    private static final List<String> STRING_FIELDS = List.of("title", "description", "index_set_title");
    private final MongoCollection<Document> collection;

    @Inject
    public PaginatedStreamService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, StreamDTO.class, COLLECTION_NAME);
        this.collection = mongoConnection.getMongoDatabase().getCollection(COLLECTION_NAME);
    }

    public long count() {
        return this.db.count();
    }

    public PaginatedList<StreamDTO> findPaginated(Bson dbQuery, Predicate<StreamDTO> predicate, int page, int perPage, String sortField, String order) {
        ImmutableList.Builder pipelineBuilder = ImmutableList.builder().add((Object)Aggregates.match((Bson)dbQuery));
        if (sortField.equals("index_set_title")) {
            pipelineBuilder.add((Object)Aggregates.lookup((String)"index_sets", List.of(new Variable("index_set_id", (Object)this.doc("$toObjectId", "$index_set_id"))), List.of(Aggregates.match((Bson)this.doc("$expr", this.doc("$eq", List.of("$_id", "$$index_set_id"))))), (String)"index_set")).add((Object)Aggregates.set((Field[])new Field[]{new Field("index_set_title", (Object)this.doc("$first", "$index_set.title"))})).add((Object)Aggregates.unset((String[])new String[]{"index_set"}));
        }
        if (this.isStringField(sortField)) {
            pipelineBuilder.add((Object)Aggregates.set((Field[])new Field[]{new Field("lower" + sortField, (Object)this.doc("$toLower", "$" + sortField))})).add((Object)Aggregates.sort((Bson)this.getSortBuilder(order, "lower" + sortField))).add((Object)Aggregates.unset((String[])new String[]{"lower" + sortField}));
        } else {
            pipelineBuilder.add((Object)Aggregates.sort((Bson)this.getSortBuilder(order, sortField)));
        }
        AggregateIterable result = this.collection.aggregate((List)pipelineBuilder.build());
        List<StreamDTO> streamsList = StreamSupport.stream(result.spliterator(), false).map(StreamDTO::fromDocument).filter(predicate).toList();
        long grandTotal = this.db.find(DBQuery.empty()).toArray().stream().filter(predicate).count();
        List<StreamDTO> paginatedStreams = perPage > 0 ? streamsList.stream().skip((long)perPage * (long)Math.max(0, page - 1)).limit(perPage).toList() : streamsList;
        return new PaginatedList<StreamDTO>(paginatedStreams, streamsList.size(), page, perPage, grandTotal);
    }

    private boolean isStringField(String sortField) {
        return STRING_FIELDS.contains(sortField);
    }

    private Document doc(String key, Object value) {
        return new Document(key, value);
    }
}

