/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.utilities;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyHostsPattern {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyHostsPattern.class);
    private static final String DELIMITER = ",";
    private final String noProxyHosts;
    private final Pattern pattern;

    private ProxyHostsPattern(String noProxyHosts, Pattern pattern) {
        this.noProxyHosts = noProxyHosts;
        this.pattern = pattern;
    }

    public String getNoProxyHosts() {
        return this.noProxyHosts;
    }

    public boolean matches(@Nullable String hostOrIp) {
        if (this.pattern == null) {
            LOG.debug("No proxy host pattern defined");
            return false;
        }
        if (Strings.isNullOrEmpty((String)hostOrIp)) {
            LOG.debug("Host or IP address <{}> doesn't match <{}>", (Object)hostOrIp, (Object)this.noProxyHosts);
            return false;
        }
        if (this.pattern.matcher(hostOrIp.toLowerCase(Locale.ROOT)).matches()) {
            LOG.debug("Host or IP address <{}> matches <{}>", (Object)hostOrIp, (Object)this.noProxyHosts);
            return true;
        }
        LOG.debug("Host or IP address <{}> doesn't match <{}>", (Object)hostOrIp, (Object)this.noProxyHosts);
        return false;
    }

    public static ProxyHostsPattern create(String noProxyHosts) {
        if (Strings.isNullOrEmpty((String)noProxyHosts)) {
            return new ProxyHostsPattern("", null);
        }
        Set patterns = Splitter.on((String)DELIMITER).trimResults().omitEmptyStrings().splitToList((CharSequence)noProxyHosts).stream().map(ProxyHostsPattern::toPattern).collect(Collectors.toSet());
        if (patterns.isEmpty()) {
            return new ProxyHostsPattern(noProxyHosts, null);
        }
        return new ProxyHostsPattern(noProxyHosts, Pattern.compile(String.join((CharSequence)"|", patterns)));
    }

    private static String toPattern(String hostPattern) {
        if (hostPattern.startsWith("*")) {
            return ".*" + Pattern.quote(hostPattern.substring(1).toLowerCase(Locale.ROOT));
        }
        if (hostPattern.endsWith("*")) {
            return Pattern.quote(hostPattern.substring(0, hostPattern.length() - 1).toLowerCase(Locale.ROOT)) + ".*";
        }
        return Pattern.quote(hostPattern);
    }
}

