/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import java.io.File;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GeoIpResolver<V> {
    private static final Logger LOG = LoggerFactory.getLogger(GeoIpResolver.class);
    protected String lastError = null;
    protected final Timer resolveTime;
    private final boolean enabled;

    GeoIpResolver(Timer resolveTime, String configPath, boolean enabled) {
        this.resolveTime = resolveTime;
        if (enabled) {
            File configFile = new File(configPath);
            if (Files.exists(configFile.toPath(), new LinkOption[0])) {
                this.enabled = this.createDataProvider(configFile);
            } else {
                LOG.warn("'{}' database file does not exist: {}", (Object)this.getClass().getName(), (Object)configPath);
                this.enabled = false;
            }
        } else {
            this.enabled = false;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    abstract boolean createDataProvider(File var1);

    public Optional<V> getGeoIpData(InetAddress address) {
        this.lastError = null;
        if (!this.enabled || address == null) {
            return Optional.empty();
        }
        return this.doGetGeoIpData(address);
    }

    public Optional<String> getLastError() {
        return Optional.ofNullable(this.lastError);
    }

    protected abstract Optional<V> doGetGeoIpData(InetAddress var1);
}

