/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport;

import com.google.common.collect.Sets;
import java.time.ZonedDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Dashboard;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.DashboardsService;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.MigrationCompleted;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Query;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomObjectIdProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RelativeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Search;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.SearchService;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.SearchType;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Titles;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.View;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewService;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewState;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidgetPosition;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Widget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.WidgetPosition;
import org.graylog2.migrations.Migration;
import org.graylog2.plugin.cluster.ClusterConfigService;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class V20191125144500_MigrateDashboardsToViews
extends Migration {
    private static final Logger LOG = LoggerFactory.getLogger(V20191125144500_MigrateDashboardsToViews.class);
    private final DashboardsService dashboardsService;
    private final SearchService searchService;
    private final ViewService viewService;
    private final ClusterConfigService clusterConfigService;
    private final RandomObjectIdProvider randomObjectIdProvider;
    private final RandomUUIDProvider randomUUIDProvider;

    @Inject
    public V20191125144500_MigrateDashboardsToViews(DashboardsService dashboardsService, SearchService searchService, ViewService viewService, ClusterConfigService clusterConfigService, RandomObjectIdProvider randomObjectIdProvider, RandomUUIDProvider randomUUIDProvider) {
        this.dashboardsService = dashboardsService;
        this.searchService = searchService;
        this.viewService = viewService;
        this.clusterConfigService = clusterConfigService;
        this.randomObjectIdProvider = randomObjectIdProvider;
        this.randomUUIDProvider = randomUUIDProvider;
    }

    @Override
    public ZonedDateTime createdAt() {
        return ZonedDateTime.parse("2019-11-25T14:45:00Z");
    }

    @Override
    public void upgrade() {
        if (this.hasBeenRunSuccessfully()) {
            LOG.debug("Migration already completed.");
            return;
        }
        HashSet<String> dashboardIdToViewId = new HashSet<String>();
        Consumer<String> recordMigratedDashboardIds = dashboardIdToViewId::add;
        HashMap<String, Set<String>> widgetIdMigrationMapping = new HashMap<String, Set<String>>();
        Consumer<Map> recordMigratedWidgetIds = widgetIdMigrationMapping::putAll;
        Map<View, Search> newViews = this.dashboardsService.streamAll().sorted(Comparator.comparing(Dashboard::id)).map(dashboard -> this.migrateDashboard((Dashboard)dashboard, recordMigratedDashboardIds, (Consumer<Map<String, Set<String>>>)recordMigratedWidgetIds)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.writeViews(newViews);
        MigrationCompleted migrationCompleted = MigrationCompleted.create(dashboardIdToViewId, widgetIdMigrationMapping);
        this.writeMigrationCompleted(migrationCompleted);
    }

    private void writeViews(Map<View, Search> newViews) {
        ArrayList writtenSearches = new ArrayList(newViews.size());
        ArrayList writtenViews = new ArrayList(newViews.size());
        try {
            newViews.forEach((view, search) -> {
                writtenSearches.add(this.searchService.save((Search)search));
                writtenViews.add(this.viewService.save((View)view));
            });
        }
        catch (Exception e) {
            LOG.warn("Exception caught while writing new views to database, rolling back: ", (Throwable)e);
            writtenSearches.forEach(this.searchService::remove);
            writtenViews.forEach(this.viewService::remove);
            throw e;
        }
    }

    private void writeMigrationCompleted(MigrationCompleted migrationCompleted) {
        this.clusterConfigService.write(migrationCompleted);
    }

    private boolean hasBeenRunSuccessfully() {
        return this.clusterConfigService.get(MigrationCompleted.class) != null;
    }

    private Map.Entry<View, Search> migrateDashboard(Dashboard dashboard, Consumer<String> recordMigratedDashboardIds, Consumer<Map<String, Set<String>>> recordMigratedWidgetMap) {
        HashMap migratedWidgetIds = new HashMap(dashboard.widgets().size());
        BiConsumer<String, String> recordMigratedWidgetIds = (before, after) -> migratedWidgetIds.merge(before, Collections.singleton(after), Sets::union);
        HashMap<String, String> newWidgetTitles = new HashMap<String, String>(dashboard.widgets().size());
        BiConsumer<String, String> recordWidgetTitle = newWidgetTitles::put;
        Set newViewWidgets = dashboard.widgets().stream().sorted(Comparator.comparing(Widget::id)).flatMap(widget -> this.migrateWidget((Widget)widget, recordMigratedWidgetIds, recordWidgetTitle).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
        Map<String, ViewWidgetPosition> newViewWidgetPositions = this.migrateWidgetPositions(dashboard, Collections.unmodifiableMap(migratedWidgetIds), Collections.unmodifiableSet(newViewWidgets));
        HashMap<String, Set<String>> newWidgetMapping = new HashMap<String, Set<String>>(newViewWidgets.size());
        BiConsumer<String, String> recordWidgetMapping = (viewWidgetId, searchTypeId) -> newWidgetMapping.merge((String)viewWidgetId, Collections.singleton(searchTypeId), Sets::union);
        DateTime createdAt = dashboard.createdAt();
        Set<SearchType> newSearchTypes = newViewWidgets.stream().flatMap(viewWidget -> this.createSearchType((ViewWidget)viewWidget, recordWidgetMapping).stream()).collect(Collectors.toSet());
        Query newQuery = Query.create(this.randomUUIDProvider.get(), RelativeRange.create(300), "", newSearchTypes);
        Set<Query> newQueries = Collections.singleton(newQuery);
        Search newSearch = Search.create(this.randomObjectIdProvider.get(), newQueries, dashboard.creatorUserId(), createdAt);
        ViewState newViewState = ViewState.create(Titles.ofWidgetTitles(newWidgetTitles).withQueryTitle(dashboard.title()), newViewWidgets, newWidgetMapping, newViewWidgetPositions);
        View newView = View.create(dashboard.id(), View.Type.DASHBOARD, dashboard.title(), "This dashboard was migrated automatically.", dashboard.description(), newSearch.id(), Collections.singletonMap(newQuery.id(), newViewState), Optional.ofNullable(dashboard.creatorUserId()), createdAt);
        recordMigratedDashboardIds.accept(dashboard.id());
        recordMigratedWidgetMap.accept(migratedWidgetIds);
        return new AbstractMap.SimpleEntry<View, Search>(newView, newSearch);
    }

    private Set<SearchType> createSearchType(ViewWidget viewWidget, BiConsumer<String, String> recordWidgetMapping) {
        Set<SearchType> searchTypes = viewWidget.toSearchTypes(this.randomUUIDProvider);
        searchTypes.forEach(searchType -> recordWidgetMapping.accept(viewWidget.id(), searchType.id()));
        return searchTypes;
    }

    private Set<ViewWidget> migrateWidget(Widget widget, BiConsumer<String, String> recordMigratedWidgetIds, BiConsumer<String, String> recordWidgetTitle) {
        Set<ViewWidget> viewWidgets = widget.toViewWidgets(this.randomUUIDProvider);
        viewWidgets.forEach(viewWidget -> {
            recordWidgetTitle.accept(viewWidget.id(), widget.description());
            recordMigratedWidgetIds.accept(widget.id(), viewWidget.id());
        });
        return viewWidgets;
    }

    private Map<String, ViewWidgetPosition> migrateWidgetPositions(Dashboard dashboard, Map<String, Set<String>> migratedWidgetIds, Set<ViewWidget> viewWidgets) {
        return dashboard.widgetPositions().entrySet().stream().flatMap(entry -> {
            WidgetPosition widgetPosition = (WidgetPosition)entry.getValue();
            Set viewWidgetIds = (Set)migratedWidgetIds.get(entry.getKey());
            if (viewWidgetIds == null) {
                return Stream.empty();
            }
            Set newViewWidgets = viewWidgetIds.stream().map(viewWidgetId -> viewWidgets.stream().filter(viewWidget -> viewWidget.id().equals(viewWidgetId)).findFirst().orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
            Optional<Widget> dashboardWidget = dashboard.widgets().stream().filter(widget -> widget.id().equals(entry.getKey())).findFirst();
            return dashboardWidget.map(widget -> widget.config().toViewWidgetPositions(newViewWidgets, widgetPosition).entrySet().stream()).orElse(Stream.empty());
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

