/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.db;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.bson.types.ObjectId;
import org.graylog.plugins.views.search.Search;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.db.SearchJobService;

@Singleton
public class InMemorySearchJobService
implements SearchJobService {
    private final Cache<String, SearchJob> cache = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.MINUTES).maximumSize(1000L).recordStats().build();

    @Inject
    public InMemorySearchJobService() {
    }

    @Override
    public SearchJob create(Search query, String owner) {
        String id = new ObjectId().toHexString();
        SearchJob searchJob = new SearchJob(id, query, owner);
        this.cache.put((Object)id, (Object)searchJob);
        return searchJob;
    }

    @Override
    public Optional<SearchJob> load(String id, String owner) {
        SearchJob searchJob = (SearchJob)this.cache.getIfPresent((Object)id);
        if (searchJob == null || !searchJob.getOwner().equals(owner)) {
            return Optional.empty();
        }
        return Optional.of(searchJob);
    }
}

