/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.security.certutil.console;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.graylog.security.certutil.console.CommandLineConsole;
import org.graylog.security.certutil.console.ConsoleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestableConsole
implements CommandLineConsole {
    private static final Logger LOG = LoggerFactory.getLogger(TestableConsole.class);
    private final List<Pair<String, String>> providedResponses = new LinkedList<Pair<String, String>>();
    private final List<String> output = new LinkedList<String>();
    private boolean silent = false;

    public static TestableConsole empty() {
        return new TestableConsole();
    }

    public TestableConsole silent() {
        this.silent = true;
        return this;
    }

    public TestableConsole register(String question, String response) {
        this.providedResponses.add((Pair<String, String>)Pair.of((Object)this.cleanQuestion(question), (Object)response));
        return this;
    }

    @Override
    public String readLine(String format, Object ... args) {
        Pair<String, String> response = this.consumeResponse(format, args);
        return (String)response.getValue();
    }

    @Override
    public char[] readPassword(String format, Object ... args) {
        Pair<String, String> response = this.consumeResponse(format, args);
        return ((String)response.getValue()).toCharArray();
    }

    @Override
    public void printLine(String line) {
        if (!this.silent) {
            LOG.info(line);
        }
        this.output.add(line);
    }

    public List<String> getOutput() {
        return this.output;
    }

    private Pair<String, String> consumeResponse(String format, Object[] args) {
        String question = this.cleanQuestion(String.format(Locale.ROOT, format, args));
        Pair response = this.providedResponses.stream().filter(r -> ((String)r.getKey()).equals(question)).findFirst().orElseThrow(() -> new ConsoleException("Unexpected input question:" + question));
        this.providedResponses.remove(response);
        return response;
    }

    private String cleanQuestion(String input) {
        return Optional.of(input).map(String::trim).map(s -> StringUtils.removeEnd((String)s, (String)":")).map(String::trim).get();
    }
}

