/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.inputs;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Set;
import java.util.stream.Stream;
import javax.inject.Singleton;
import org.graylog2.plugin.IOState;
import org.graylog2.plugin.inputs.MessageInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InputRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(InputRegistry.class);
    private final Set<IOState<MessageInput>> inputStates = Sets.newConcurrentHashSet();

    public Set<IOState<MessageInput>> getInputStates() {
        return ImmutableSet.copyOf(this.inputStates);
    }

    public IOState<MessageInput> getInputState(String inputId) {
        for (IOState<MessageInput> inputState : this.inputStates) {
            if (!inputState.getStoppable().getPersistId().equals(inputId)) continue;
            return inputState;
        }
        return null;
    }

    public Set<IOState<MessageInput>> getRunningInputs() {
        ImmutableSet.Builder runningInputs = ImmutableSet.builder();
        for (IOState<MessageInput> inputState : this.inputStates) {
            if (inputState.getState() != IOState.Type.RUNNING) continue;
            runningInputs.add(inputState);
        }
        return runningInputs.build();
    }

    public boolean hasTypeRunning(Class klazz) {
        for (IOState<MessageInput> inputState : this.inputStates) {
            if (!inputState.getStoppable().getClass().equals(klazz)) continue;
            return true;
        }
        return false;
    }

    public int runningCount() {
        return this.getRunningInputs().size();
    }

    public MessageInput getRunningInput(String inputId) {
        for (IOState<MessageInput> inputState : this.inputStates) {
            if (!inputState.getStoppable().getId().equals(inputId)) continue;
            return inputState.getStoppable();
        }
        return null;
    }

    public IOState<MessageInput> getRunningInputState(String inputStateId) {
        for (IOState<MessageInput> inputState : this.inputStates) {
            if (!inputState.getStoppable().getId().equals(inputStateId)) continue;
            return inputState;
        }
        return null;
    }

    public boolean remove(MessageInput input) {
        IOState<MessageInput> inputState = this.stop(input);
        input.terminate();
        if (inputState != null) {
            inputState.setState(IOState.Type.TERMINATED);
        }
        return this.inputStates.remove(inputState);
    }

    public boolean remove(IOState<MessageInput> inputState) {
        MessageInput messageInput = inputState.getStoppable();
        return this.remove(messageInput);
    }

    public IOState<MessageInput> stop(MessageInput input) {
        IOState<MessageInput> inputState = this.getRunningInputState(input.getId());
        if (inputState != null) {
            inputState.setState(IOState.Type.STOPPING);
            try {
                input.stop();
            }
            catch (Exception e) {
                LOG.warn("Stopping input {} failed, removing anyway: {}", (Object)input.toIdentifier(), (Object)e);
            }
            inputState.setState(IOState.Type.STOPPED);
        }
        return inputState;
    }

    public boolean add(IOState<MessageInput> messageInputIOState) {
        return this.inputStates.add(messageInputIOState);
    }

    public Stream<IOState<MessageInput>> stream() {
        return this.inputStates.stream();
    }
}

