/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.shared.metrics;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jvm.BufferPoolMetricSet;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import java.lang.management.ManagementFactory;
import javax.inject.Singleton;
import org.graylog2.shared.metrics.CustomMemoryUsageGaugeSet;

@Singleton
public class MetricRegistryFactory {
    public static MetricRegistry create() {
        MetricRegistry metricRegistry = new MetricRegistry();
        metricRegistry.register("jvm.buffers", (Metric)new BufferPoolMetricSet(ManagementFactory.getPlatformMBeanServer()));
        metricRegistry.register("jvm.cl", (Metric)new ClassLoadingGaugeSet());
        metricRegistry.register("jvm.gc", (Metric)new GarbageCollectorMetricSet());
        metricRegistry.register("jvm.memory", (Metric)new CustomMemoryUsageGaugeSet());
        metricRegistry.register("jvm.threads", (Metric)new ThreadStatesGaugeSet());
        return metricRegistry;
    }
}

