/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.beats;

import java.util.HashMap;
import java.util.Map;

public final class MapUtils {
    public static Map<String, Object> flatten(Map<String, Object> originalMap, String parentKey, String separator) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : originalMap.entrySet()) {
            String key = parentKey.isEmpty() ? entry.getKey() : parentKey + separator + entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                Map valueMap = (Map)value;
                result.putAll(MapUtils.flatten(valueMap, key, separator));
                continue;
            }
            result.put(key, value);
        }
        return result;
    }

    public static void renameKey(Map<String, Object> map, String originalKey, String newKey) {
        if (map.containsKey(originalKey)) {
            Object value = map.remove(originalKey);
            map.put(newKey, value);
        }
    }

    public static Map<String, Object> replaceKeyCharacter(Map<String, Object> map, char oldChar, char newChar) {
        HashMap<String, Object> result = new HashMap<String, Object>(map.size());
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().replace(oldChar, newChar);
            Object value = entry.getValue();
            result.put(key, value);
        }
        return result;
    }

    private MapUtils() {
        throw new AssertionError((Object)"No instances allowed");
    }
}

