/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.functions.strings;

import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.functions.AbstractFunction;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionArgs;
import org.graylog.plugins.pipelineprocessor.ast.functions.FunctionDescriptor;
import org.graylog.plugins.pipelineprocessor.ast.functions.ParameterDescriptor;

public class Join
extends AbstractFunction<String> {
    public static final String NAME = "join";
    private final ParameterDescriptor<String, String> delimiterParam;
    private final ParameterDescriptor<Object, List> elementsParam = ParameterDescriptor.type("elements", Object.class, List.class).transform(Join::toList).description("The list of strings to join together, may be null").build();
    private final ParameterDescriptor<Long, Integer> startIndexParam;
    private final ParameterDescriptor<Long, Integer> endIndexParam;

    public Join() {
        this.delimiterParam = ParameterDescriptor.string("delimiter").optional().description("The delimiter that separates each element. Default: none").build();
        this.startIndexParam = ParameterDescriptor.integer("start", Integer.class).optional().transform(Ints::saturatedCast).description("The first index to start joining from. It is an error to pass in an index larger than the number of elements").build();
        this.endIndexParam = ParameterDescriptor.integer("indexEnd", Integer.class).optional().transform(Ints::saturatedCast).description("The index to stop joining from (exclusive). It is an error to pass in an index larger than the number of elements").build();
    }

    private static List toList(Object obj) {
        if (obj instanceof Collection) {
            return ImmutableList.copyOf((Collection)((Collection)obj));
        }
        throw new IllegalArgumentException("Unsupported data type for parameter 'elements': " + obj.getClass().getCanonicalName());
    }

    @Override
    public String evaluate(FunctionArgs args, EvaluationContext context) {
        List elements = this.elementsParam.optional(args, context).orElse(Collections.emptyList());
        int length = elements.size();
        String delimiter = this.delimiterParam.required(args, context);
        int startIndex = this.startIndexParam.optional(args, context).filter(idx -> idx >= 0).orElse(0);
        int endIndex = this.endIndexParam.optional(args, context).filter(idx -> idx >= 0).orElse(length);
        return StringUtils.join(elements.subList(startIndex, endIndex), (String)delimiter);
    }

    @Override
    public FunctionDescriptor<String> descriptor() {
        return FunctionDescriptor.builder().name(NAME).pure(true).returnType(String.class).params((ImmutableList<ParameterDescriptor>)ImmutableList.of(this.elementsParam, this.delimiterParam, this.startIndexParam, this.endIndexParam)).description("Joins the elements of the provided array into a single String").build();
    }
}

