/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.rest.scriptingapi.request.SearchRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseEntryDataType;
import org.graylog.plugins.views.search.rest.scriptingapi.response.ResponseSchemaEntry;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

public record MessagesRequestSpec(@JsonProperty(value="query") String queryString, @JsonProperty(value="streams") Set<String> streams, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="sort") String sort, @JsonProperty(value="sort_order") SortSpec.Direction sortOrder, @JsonProperty(value="from") int from, @JsonProperty(value="size") int size, @JsonProperty(value="fields") List<String> fields) implements SearchRequestSpec
{
    public static final List<String> DEFAULT_FIELDS = List.of("source", "timestamp");
    public static final String DEFAULT_SORT = "timestamp";
    public static final SortSpec.Direction DEFAULT_SORT_ORDER = SortSpec.Direction.Descending;
    public static final int DEFAULT_SIZE = 10;
    public static final int DEFAULT_FROM = 0;

    public MessagesRequestSpec {
        if (Strings.isNullOrEmpty((String)queryString)) {
            queryString = "*";
        }
        if (Strings.isNullOrEmpty((String)sort)) {
            sort = DEFAULT_SORT;
        }
        if (sortOrder == null) {
            sortOrder = DEFAULT_SORT_ORDER;
        }
        if (timerange == null) {
            timerange = DEFAULT_TIMERANGE;
        }
        if (streams == null) {
            streams = Set.of();
        }
        if (from < 0) {
            from = 0;
        }
        if (size <= 0) {
            size = 10;
        }
        if (fields == null || fields.isEmpty()) {
            fields = DEFAULT_FIELDS;
        }
    }

    @JsonIgnore
    public List<ResponseSchemaEntry> getSchema(Map<String, String> fieldTypes) {
        return this.fields().stream().map(field -> {
            String type = fieldTypes.getOrDefault(field, null);
            return ResponseSchemaEntry.field(field, ResponseEntryDataType.fromSearchEngineType(type));
        }).collect(Collectors.toList());
    }
}

