/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.contentpacks.model.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SortSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.Values;
import org.graylog.plugins.views.search.timeranges.DerivedTimeRange;
import org.graylog.plugins.views.search.timeranges.OffsetRange;
import org.graylog2.contentpacks.model.entities.AutoValue_PivotEntity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.SearchTypeEntity;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.KeywordRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;

@JsonTypeName(value="pivot")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class PivotEntity
implements SearchTypeEntity {
    public static final String NAME = "pivot";

    @Override
    public abstract String type();

    @Override
    @Nullable
    @JsonProperty
    public abstract String id();

    @Override
    @JsonProperty
    public abstract Optional<String> name();

    @JsonProperty(value="row_groups")
    public abstract List<BucketSpec> rowGroups();

    @JsonProperty(value="column_groups")
    public abstract List<BucketSpec> columnGroups();

    @JsonProperty
    public abstract List<SeriesSpec> series();

    @JsonProperty
    public abstract List<SortSpec> sort();

    @JsonProperty
    public abstract boolean rollup();

    @Override
    @Nullable
    public abstract Filter filter();

    @Override
    @JsonProperty(value="filters")
    public abstract List<UsedSearchFilter> filters();

    @JsonProperty(value="row_limit")
    public abstract Optional<Integer> rowLimit();

    @JsonProperty(value="column_limit")
    public abstract Optional<Integer> columnLimit();

    public abstract Builder toBuilder();

    @Override
    public Builder toGenericBuilder() {
        return this.toBuilder();
    }

    public static Builder builder() {
        return new AutoValue_PivotEntity.Builder().type(NAME).rowGroups((List<BucketSpec>)ImmutableList.of()).columnGroups((List<BucketSpec>)ImmutableList.of()).filters(Collections.emptyList()).sort((List<SortSpec>)ImmutableList.of()).streams(Collections.emptySet());
    }

    @Override
    public SearchType toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        List<BucketSpec> rowGroups = this.rowLimit().map(rowLimit -> this.applyGroupLimit(this.rowGroups(), (int)rowLimit)).orElse(this.rowGroups());
        List<BucketSpec> columnGroups = this.columnLimit().map(columnLimit -> this.applyGroupLimit(this.columnGroups(), (int)columnLimit)).orElse(this.columnGroups());
        return Pivot.builder().streams(this.mappedStreams(nativeEntities)).name(this.name().orElse(null)).sort(this.sort()).timerange((DerivedTimeRange)this.timerange().orElse(null)).rowGroups(rowGroups).columnGroups(columnGroups).series(this.series()).rollup(this.rollup()).query(this.query().orElse(null)).filter(this.filter()).filters(this.filters()).type(this.type()).id(this.id()).build();
    }

    private List<BucketSpec> applyGroupLimit(List<BucketSpec> bucketSpecs, int limit) {
        return bucketSpecs.stream().map(rowGroup -> {
            if (rowGroup instanceof Values) {
                Values values = (Values)rowGroup;
                return values.withLimit(limit);
            }
            return rowGroup;
        }).toList();
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements SearchTypeEntity.Builder {
        @JsonCreator
        public static Builder createDefault() {
            return PivotEntity.builder().filters(Collections.emptyList()).sort(Collections.emptyList()).streams(Collections.emptySet());
        }

        @JsonProperty
        public abstract Builder type(String var1);

        @JsonProperty
        public abstract Builder id(@Nullable String var1);

        @JsonProperty
        public abstract Builder name(@Nullable String var1);

        @JsonProperty(value="row_groups")
        public abstract Builder rowGroups(List<BucketSpec> var1);

        @JsonProperty(value="column_groups")
        public abstract Builder columnGroups(List<BucketSpec> var1);

        @JsonProperty(value="row_limit")
        public abstract Builder rowLimit(@Nullable Integer var1);

        @JsonProperty(value="column_limit")
        public abstract Builder columnLimit(@Nullable Integer var1);

        @JsonProperty
        public abstract Builder series(List<SeriesSpec> var1);

        @JsonProperty
        public abstract Builder sort(List<SortSpec> var1);

        @JsonProperty
        public abstract Builder rollup(boolean var1);

        @JsonProperty
        public abstract Builder filter(@Nullable Filter var1);

        @JsonProperty
        public abstract Builder filters(List<UsedSearchFilter> var1);

        @JsonProperty
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type", visible=false)
        @JsonSubTypes(value={@JsonSubTypes.Type(name="absolute", value=AbsoluteRange.class), @JsonSubTypes.Type(name="relative", value=RelativeRange.class), @JsonSubTypes.Type(name="keyword", value=KeywordRange.class), @JsonSubTypes.Type(name="offset", value=OffsetRange.class)})
        public Builder timerange(@Nullable TimeRange timerange) {
            return this.timerange(timerange == null ? null : DerivedTimeRange.of(timerange));
        }

        public abstract Builder timerange(@Nullable DerivedTimeRange var1);

        @JsonProperty
        public abstract Builder query(@Nullable BackendQuery var1);

        @Override
        @JsonProperty
        public abstract Builder streams(Set<String> var1);

        @Override
        public abstract PivotEntity build();
    }
}

