/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.indexer.indices.jobs;

import com.google.inject.assistedinject.Assisted;
import javax.inject.Inject;
import org.graylog2.indexer.IndexSetRegistry;
import org.graylog2.indexer.SetIndexReadOnlyJob;
import org.graylog2.indexer.fieldtypes.IndexFieldTypePoller;
import org.graylog2.indexer.fieldtypes.IndexFieldTypesService;
import org.graylog2.indexer.indices.Indices;
import org.graylog2.indexer.ranges.CreateNewSingleIndexRangeJob;
import org.graylog2.system.jobs.SystemJob;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SetIndexReadOnlyAndCalculateRangeJob
extends SystemJob {
    private static final Logger LOG = LoggerFactory.getLogger(SetIndexReadOnlyAndCalculateRangeJob.class);
    private final SetIndexReadOnlyJob.Factory setIndexReadOnlyJobFactory;
    private final CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory;
    private final IndexSetRegistry indexSetRegistry;
    private final Indices indices;
    private final IndexFieldTypesService indexFieldTypesService;
    private final IndexFieldTypePoller indexFieldTypePoller;
    private final String indexName;

    @Inject
    public SetIndexReadOnlyAndCalculateRangeJob(SetIndexReadOnlyJob.Factory setIndexReadOnlyJobFactory, CreateNewSingleIndexRangeJob.Factory createNewSingleIndexRangeJobFactory, IndexSetRegistry indexSetRegistry, Indices indices, IndexFieldTypesService indexFieldTypesService, IndexFieldTypePoller indexFieldTypePoller, @Assisted String indexName) {
        this.setIndexReadOnlyJobFactory = setIndexReadOnlyJobFactory;
        this.createNewSingleIndexRangeJobFactory = createNewSingleIndexRangeJobFactory;
        this.indexSetRegistry = indexSetRegistry;
        this.indices = indices;
        this.indexFieldTypesService = indexFieldTypesService;
        this.indexFieldTypePoller = indexFieldTypePoller;
        this.indexName = indexName;
    }

    @Override
    public void execute() {
        if (!this.indices.exists(this.indexName)) {
            LOG.debug("Not running job for deleted index <{}>", (Object)this.indexName);
            return;
        }
        if (this.indices.isClosed(this.indexName)) {
            LOG.debug("Not running job for closed index <{}>", (Object)this.indexName);
            return;
        }
        SetIndexReadOnlyJob setIndexReadOnlyJob = this.setIndexReadOnlyJobFactory.create(this.indexName);
        ((SystemJob)setIndexReadOnlyJob).execute();
        CreateNewSingleIndexRangeJob createNewSingleIndexRangeJob = this.createNewSingleIndexRangeJobFactory.create(this.indexSetRegistry.getAll(), this.indexName);
        ((SystemJob)createNewSingleIndexRangeJob).execute();
        this.indexSetRegistry.getForIndex(this.indexName).ifPresent(indexSet -> this.indexFieldTypePoller.pollIndex(this.indexName, indexSet.getConfig().id()).ifPresent(this.indexFieldTypesService::upsert));
    }

    @Override
    public void requestCancel() {
    }

    @Override
    public int getProgress() {
        return 0;
    }

    @Override
    public int maxConcurrency() {
        return 1000;
    }

    @Override
    public boolean providesProgress() {
        return false;
    }

    @Override
    public boolean isCancelable() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Makes index " + this.indexName + " read only and calculates and adds its index range afterwards.";
    }

    @Override
    public String getClassName() {
        return this.getClass().getCanonicalName();
    }

    public static interface Factory {
        public SetIndexReadOnlyAndCalculateRangeJob create(String var1);
    }
}

