/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.rest.resources.entities.preferences.listeners;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog2.rest.resources.entities.preferences.service.EntityListPreferencesService;
import org.graylog2.users.events.UserDeletedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class EntityListPreferencesCleanerOnUserDeletion {
    private static final Logger LOG = LoggerFactory.getLogger(EntityListPreferencesCleanerOnUserDeletion.class);
    private final EntityListPreferencesService entityListPreferencesService;

    @Inject
    public EntityListPreferencesCleanerOnUserDeletion(EventBus eventBus, EntityListPreferencesService entityListPreferencesService) {
        this.entityListPreferencesService = entityListPreferencesService;
        eventBus.register((Object)this);
    }

    @Subscribe
    public void handleUserDeletedEvent(UserDeletedEvent event) {
        LOG.debug("Removing entity list preferences of user <{}/{}>", (Object)event.userName(), (Object)event.userId());
        this.entityListPreferencesService.deleteAllForUser(event.userId());
    }
}

