/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.contentpack.entities;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.MutableGraph;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.events.contentpack.entities.AutoValue_AggregationEventProcessorConfigEntity;
import org.graylog.events.contentpack.entities.EventProcessorConfigEntity;
import org.graylog.events.processor.EventProcessorConfig;
import org.graylog.events.processor.aggregation.AggregationConditions;
import org.graylog.events.processor.aggregation.AggregationEventProcessorConfig;
import org.graylog.events.processor.aggregation.AggregationSeries;
import org.graylog2.contentpacks.exceptions.ContentPackException;
import org.graylog2.contentpacks.model.ModelId;
import org.graylog2.contentpacks.model.ModelTypes;
import org.graylog2.contentpacks.model.entities.Entity;
import org.graylog2.contentpacks.model.entities.EntityDescriptor;
import org.graylog2.contentpacks.model.entities.EntityV1;
import org.graylog2.contentpacks.model.entities.references.ValueReference;
import org.graylog2.plugin.streams.Stream;

@JsonTypeName(value="aggregation-v1")
@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationEventProcessorConfigEntity
implements EventProcessorConfigEntity {
    public static final String TYPE_NAME = "aggregation-v1";
    private static final String FIELD_QUERY = "query";
    private static final String FIELD_STREAMS = "streams";
    private static final String FIELD_GROUP_BY = "group_by";
    private static final String FIELD_SERIES = "series";
    private static final String FIELD_CONDITIONS = "conditions";
    private static final String FIELD_SEARCH_WITHIN_MS = "search_within_ms";
    private static final String FIELD_EXECUTE_EVERY_MS = "execute_every_ms";

    @JsonProperty(value="query")
    public abstract ValueReference query();

    @JsonProperty(value="streams")
    public abstract ImmutableSet<String> streams();

    @JsonProperty(value="group_by")
    public abstract List<String> groupBy();

    @JsonProperty(value="series")
    public abstract List<AggregationSeries> series();

    @JsonProperty(value="conditions")
    public abstract Optional<AggregationConditions> conditions();

    @JsonProperty(value="search_within_ms")
    public abstract long searchWithinMs();

    @JsonProperty(value="execute_every_ms")
    public abstract long executeEveryMs();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    @Override
    public EventProcessorConfig toNativeEntity(Map<String, ValueReference> parameters, Map<EntityDescriptor, Object> nativeEntities) {
        ImmutableSet streamSet = ImmutableSet.copyOf((Collection)this.streams().stream().map(id -> EntityDescriptor.create(id, ModelTypes.STREAM_V1)).map(nativeEntities::get).map(object -> {
            if (object == null) {
                throw new ContentPackException("Missing Stream for event definition");
            }
            if (object instanceof Stream) {
                Stream stream = (Stream)object;
                return stream.getId();
            }
            throw new ContentPackException("Invalid type for stream Stream for event definition: " + object.getClass());
        }).collect(Collectors.toSet()));
        return ((AggregationEventProcessorConfig.Builder)AggregationEventProcessorConfig.builder().type(this.type())).query(this.query().asString(parameters)).streams((Set<String>)streamSet).groupBy(this.groupBy()).series(this.series()).conditions(this.conditions().orElse(null)).executeEveryMs(this.executeEveryMs()).searchWithinMs(this.searchWithinMs()).build();
    }

    @Override
    public void resolveForInstallation(EntityV1 entity, Map<String, ValueReference> parameters, Map<EntityDescriptor, Entity> entities, MutableGraph<Entity> graph) {
        this.streams().stream().map(ModelId::of).map(modelId -> EntityDescriptor.create(modelId, ModelTypes.STREAM_V1)).map(entities::get).filter(Objects::nonNull).forEach(stream -> graph.putEdge((Object)entity, stream));
    }

    @AutoValue.Builder
    public static abstract class Builder
    implements EventProcessorConfigEntity.Builder<Builder> {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AggregationEventProcessorConfigEntity.Builder().type(AggregationEventProcessorConfigEntity.TYPE_NAME);
        }

        @JsonProperty(value="query")
        public abstract Builder query(ValueReference var1);

        @JsonProperty(value="streams")
        public abstract Builder streams(ImmutableSet<String> var1);

        @JsonProperty(value="group_by")
        public abstract Builder groupBy(List<String> var1);

        @JsonProperty(value="series")
        public abstract Builder series(List<AggregationSeries> var1);

        @JsonProperty(value="conditions")
        public abstract Builder conditions(@Nullable AggregationConditions var1);

        @JsonProperty(value="search_within_ms")
        public abstract Builder searchWithinMs(long var1);

        @JsonProperty(value="execute_every_ms")
        public abstract Builder executeEveryMs(long var1);

        public abstract AggregationEventProcessorConfigEntity build();
    }
}

