/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.notifications;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.graylog.events.notifications.EventNotification;
import org.graylog.events.notifications.NotificationDto;
import org.graylog2.shared.metrics.MetricUtils;

@Singleton
public class EventNotificationExecutionMetrics {
    private final MetricRegistry metricRegistry;
    private final String PREFIX = "executions";

    @Inject
    public EventNotificationExecutionMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
    }

    void registerEventNotification(EventNotification eventNotification, NotificationDto notification) {
        for (Fields field : Fields.values()) {
            String name = this.getNameforField(eventNotification, notification, field);
            MetricUtils.safelyRegister(this.metricRegistry, this.getNameforField(eventNotification, notification, field), new Meter());
        }
    }

    void markExecution(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.TOTAL).mark();
    }

    void markSuccess(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.SUCCESSFUL).mark();
    }

    void markInGrace(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.IN_GRACE_PERIOD).mark();
    }

    void markFailedTemporarily(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.FAILED_TEMPORARILY).mark();
    }

    void markFailedPermanently(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.FAILED_PERMANENTLY).mark();
    }

    void markFailed(EventNotification eventNotification, NotificationDto notification) {
        this.getMeterforField(eventNotification, notification, Fields.FAILED_OTHER).mark();
    }

    private String getNameforField(EventNotification eventNotification, NotificationDto notification, Fields field) {
        return MetricRegistry.name(eventNotification.getClass(), (String[])new String[]{notification.id(), "executions", field.toString().toLowerCase(Locale.ROOT)});
    }

    private Meter getMeterforField(EventNotification eventNotification, NotificationDto notification, Fields field) {
        return MetricUtils.getOrRegister(this.metricRegistry, this.getNameforField(eventNotification, notification, field), new Meter());
    }

    private static enum Fields {
        TOTAL,
        SUCCESSFUL,
        FAILED_OTHER,
        FAILED_TEMPORARILY,
        FAILED_PERMANENTLY,
        IN_GRACE_PERIOD;

    }
}

