/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import org.bson.types.ObjectId;
import org.graylog.events.processor.EventProcessorStateDto;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.MongoDBUpsertRetryer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.mongojack.DBQuery;
import org.mongojack.DBUpdate;
import org.mongojack.JacksonDBCollection;
import org.mongojack.internal.update.SingleUpdateOperationValue;
import org.mongojack.internal.update.UpdateOperationValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBEventProcessorStateService {
    private static final Logger LOG = LoggerFactory.getLogger(DBEventProcessorStateService.class);
    private static final String COLLECTION_NAME = "event_processor_state";
    private final JacksonDBCollection<EventProcessorStateDto, ObjectId> db;

    @Inject
    public DBEventProcessorStateService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        this.db = JacksonDBCollection.wrap((DBCollection)mongoConnection.getDatabase().getCollection(COLLECTION_NAME), EventProcessorStateDto.class, ObjectId.class, (ObjectMapper)mapper.get());
        this.db.createIndex((DBObject)new BasicDBObject("event_definition_id", (Object)1), (DBObject)new BasicDBObject("unique", (Object)true));
        this.db.createIndex((DBObject)new BasicDBObject("min_processed_timestamp", (Object)1));
        this.db.createIndex((DBObject)new BasicDBObject("max_processed_timestamp", (Object)1));
    }

    @VisibleForTesting
    Optional<EventProcessorStateDto> findByEventDefinitionId(String eventDefinitionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventDefinitionId) ? 1 : 0) != 0, (Object)"eventDefinitionId cannot be null or empty");
        return Optional.ofNullable((EventProcessorStateDto)this.db.findOne(DBQuery.is((String)"event_definition_id", (Object)eventDefinitionId)));
    }

    public ImmutableSet<EventProcessorStateDto> findByEventDefinitionsAndMaxTimestamp(Set<String> eventDefinitionIds, DateTime maxTimestamp) {
        Preconditions.checkArgument((eventDefinitionIds != null && !eventDefinitionIds.isEmpty() ? 1 : 0) != 0, (Object)"eventDefinitionIds cannot be null or empty");
        Preconditions.checkArgument((maxTimestamp != null ? 1 : 0) != 0, (Object)"maxTimestamp cannot be null");
        DBQuery.Query query = DBQuery.and((DBQuery.Query[])new DBQuery.Query[]{DBQuery.in((String)"event_definition_id", eventDefinitionIds), DBQuery.greaterThanEquals((String)"max_processed_timestamp", (Object)maxTimestamp)});
        return ImmutableSet.copyOf((Iterator)this.db.find(query).iterator());
    }

    public Optional<EventProcessorStateDto> setState(EventProcessorStateDto dto) {
        return this.setState(dto.eventDefinitionId(), dto.minProcessedTimestamp(), dto.maxProcessedTimestamp());
    }

    public Optional<EventProcessorStateDto> setState(String eventDefinitionId, DateTime minProcessedTimestamp, DateTime maxProcessedTimestamp) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)eventDefinitionId) ? 1 : 0) != 0, (Object)"eventDefinitionId cannot be null or empty");
        Preconditions.checkArgument((minProcessedTimestamp != null ? 1 : 0) != 0, (Object)"minProcessedTimestamp cannot be null");
        Preconditions.checkArgument((maxProcessedTimestamp != null ? 1 : 0) != 0, (Object)"maxProcessedTimestamp cannot be null");
        Preconditions.checkArgument((boolean)maxProcessedTimestamp.isAfter((ReadableInstant)minProcessedTimestamp), (Object)"minProcessedTimestamp must be older than maxProcessedTimestamp");
        LOG.debug("Update event processor state for <{}> with min processed timestamp of <{}> max processed timestamp of <{}>", new Object[]{eventDefinitionId, minProcessedTimestamp, maxProcessedTimestamp});
        DBUpdate.Builder update = DBUpdate.set((String)"event_definition_id", (Object)eventDefinitionId).addOperation("$min", "min_processed_timestamp", (UpdateOperationValue)this.updateValue(minProcessedTimestamp)).addOperation("$max", "max_processed_timestamp", (UpdateOperationValue)this.updateValue(maxProcessedTimestamp));
        return Optional.ofNullable(MongoDBUpsertRetryer.run(() -> (EventProcessorStateDto)this.db.findAndModify(DBQuery.is((String)"event_definition_id", (Object)eventDefinitionId), null, null, false, update, true, true)));
    }

    private SingleUpdateOperationValue updateValue(Object value) {
        return new SingleUpdateOperationValue(false, true, value);
    }

    public int deleteByEventDefinitionId(String id) {
        return this.findByEventDefinitionId(id).map(dto -> this.db.removeById((Object)new ObjectId(Objects.requireNonNull(dto.id()))).getN()).orElse(0);
    }
}

