/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.events.processor.aggregation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import org.graylog.events.processor.aggregation.AggregationKeyResult;
import org.graylog.events.processor.aggregation.AutoValue_AggregationResult;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;

@JsonDeserialize(builder=Builder.class)
@AutoValue
public abstract class AggregationResult {
    private static final AggregationResult EMPTY_AGGREGATION_RESULT = AggregationResult.builder().keyResults((List<AggregationKeyResult>)ImmutableList.of()).effectiveTimerange(AbsoluteRange.create(Tools.nowUTC(), Tools.nowUTC())).totalAggregatedMessages(0L).sourceStreams((Set<String>)ImmutableSet.of()).build();

    public abstract ImmutableList<AggregationKeyResult> keyResults();

    public abstract AbsoluteRange effectiveTimerange();

    public abstract long totalAggregatedMessages();

    public abstract Set<String> sourceStreams();

    public static Builder builder() {
        return Builder.create();
    }

    public abstract Builder toBuilder();

    public static AggregationResult empty() {
        return EMPTY_AGGREGATION_RESULT;
    }

    @AutoValue.Builder
    public static abstract class Builder {
        @JsonCreator
        public static Builder create() {
            return new AutoValue_AggregationResult.Builder();
        }

        public abstract Builder keyResults(List<AggregationKeyResult> var1);

        public abstract Builder effectiveTimerange(AbsoluteRange var1);

        public abstract Builder totalAggregatedMessages(long var1);

        public abstract Builder sourceStreams(Set<String> var1);

        public abstract AggregationResult build();
    }
}

