/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.metrics.prometheus;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.github.joschi.jadconfig.util.Duration;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.AbstractIdleService;
import io.prometheus.client.Collector;
import io.prometheus.client.dropwizard.DropwizardExports;
import io.prometheus.client.dropwizard.samplebuilder.CustomMappingSampleBuilder;
import io.prometheus.client.dropwizard.samplebuilder.MapperConfig;
import io.prometheus.client.dropwizard.samplebuilder.SampleBuilder;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.graylog.metrics.prometheus.PrometheusExporterHTTPServer;
import org.graylog.metrics.prometheus.PrometheusMetricFilter;
import org.graylog.metrics.prometheus.mapping.PrometheusMappingFilesHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PrometheusExporter
extends AbstractIdleService {
    private static final Logger LOG = LoggerFactory.getLogger(PrometheusExporter.class);
    private final boolean enabled;
    private final ScheduledExecutorService scheduler;
    private final MetricRegistry metricRegistry;
    private final Provider<PrometheusMappingFilesHandler> mappingFilesHandlerProvider;
    private final PrometheusExporterHTTPServer httpServer;
    private final long refreshIntervalMs;
    private ScheduledFuture<?> refreshFuture;
    private PrometheusMappingFilesHandler mappingFilesHandler;

    @Inject
    public PrometheusExporter(@Named(value="prometheus_exporter_enabled") boolean enabled, @Named(value="prometheus_exporter_bind_address") HostAndPort bindAddress, @Named(value="prometheus_exporter_mapping_file_refresh_interval") Duration mappingFileRefreshInterval, @Named(value="daemonScheduler") ScheduledExecutorService scheduler, MetricRegistry metricRegistry, Provider<PrometheusMappingFilesHandler> mappingFilesHandlerProvider, PrometheusExporterHTTPServer.Factory httpServerFactory) {
        this.enabled = enabled;
        this.scheduler = scheduler;
        this.metricRegistry = metricRegistry;
        this.mappingFilesHandlerProvider = mappingFilesHandlerProvider;
        this.httpServer = httpServerFactory.create(bindAddress);
        this.refreshIntervalMs = mappingFileRefreshInterval.toMilliseconds();
    }

    protected void startUp() throws Exception {
        if (!this.enabled) {
            LOG.debug("Exporter disabled");
            return;
        }
        this.createMappingFilesHandler();
        this.httpServer.replaceCollector(this.createCollector(this.mappingFilesHandler.getMapperConfigs()));
        this.httpServer.start();
        this.refreshFuture = this.scheduler.scheduleAtFixedRate(this::refresh, this.refreshIntervalMs, this.refreshIntervalMs, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() throws Exception {
        this.httpServer.stop();
        if (this.refreshFuture != null) {
            this.refreshFuture.cancel(true);
        }
    }

    private void refresh() {
        if (!this.enabled) {
            LOG.debug("Exporter disabled or HTTP server not running, no need to refresh the mappings.");
            return;
        }
        try {
            if (this.mappingFilesHandler.filesHaveChanged()) {
                this.httpServer.replaceCollector(this.createCollector(this.mappingFilesHandler.getMapperConfigs()));
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't refresh mapping files", (Throwable)e);
        }
    }

    private Collector createCollector(List<MapperConfig> mapperConfigs) {
        return new DropwizardExports(this.metricRegistry, (MetricFilter)new PrometheusMetricFilter(mapperConfigs), (SampleBuilder)new CustomMappingSampleBuilder(mapperConfigs));
    }

    public Collector createCollector() {
        this.createMappingFilesHandler();
        return this.createCollector(this.mappingFilesHandler.getMapperConfigs());
    }

    private void createMappingFilesHandler() {
        if (Objects.isNull(this.mappingFilesHandler)) {
            this.mappingFilesHandler = (PrometheusMappingFilesHandler)this.mappingFilesHandlerProvider.get();
        }
    }
}

