/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.map.geoip;

import com.codahale.metrics.Timer;
import com.maxmind.geoip2.DatabaseReader;
import java.io.File;
import java.io.IOException;
import org.graylog.plugins.map.geoip.GeoIpResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class MaxMindIpResolver<T>
extends GeoIpResolver<T> {
    protected static final Logger LOG = LoggerFactory.getLogger(MaxMindIpResolver.class);
    protected DatabaseReader databaseReader;

    MaxMindIpResolver(Timer resolveTime, String configPath, boolean enabled) {
        super(resolveTime, configPath, enabled);
    }

    @Override
    boolean createDataProvider(File configFile) {
        try {
            this.databaseReader = new DatabaseReader.Builder(configFile).build();
        }
        catch (IOException e) {
            LOG.warn("Error creating DatabaseReader for '{}' with config file '{}'", (Object)this.getClass().getSimpleName(), (Object)configFile);
            this.databaseReader = null;
        }
        return this.databaseReader != null;
    }
}

