/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.pipelineprocessor.ast.expressions;

import com.google.common.base.MoreObjects;
import javax.annotation.Nullable;
import org.antlr.v4.runtime.Token;
import org.graylog.plugins.pipelineprocessor.EvaluationContext;
import org.graylog.plugins.pipelineprocessor.ast.expressions.BinaryExpression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.Expression;
import org.graylog.plugins.pipelineprocessor.ast.expressions.NumericExpression;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;

public class AdditionExpression
extends BinaryExpression
implements NumericExpression {
    private final boolean isPlus;
    private Class type = Void.class;

    public AdditionExpression(Token start, Expression left, Expression right, boolean isPlus) {
        super(start, left, right);
        this.isPlus = isPlus;
    }

    @Override
    public boolean isIntegral() {
        return this.getType().equals(Long.class);
    }

    @Override
    public long evaluateLong(EvaluationContext context) {
        return (Long)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0);
    }

    @Override
    public double evaluateDouble(EvaluationContext context) {
        return (Double)MoreObjects.firstNonNull((Object)this.evaluateUnsafe(context), (Object)0.0);
    }

    @Override
    @Nullable
    public Object evaluateUnsafe(EvaluationContext context) {
        Object leftValue = this.left.evaluateUnsafe(context);
        Object rightValue = this.right.evaluateUnsafe(context);
        boolean leftDate = DateTime.class.equals(leftValue.getClass());
        boolean leftPeriod = Period.class.equals(leftValue.getClass());
        boolean rightDate = DateTime.class.equals(rightValue.getClass());
        boolean rightPeriod = Period.class.equals(rightValue.getClass());
        if (leftDate && rightPeriod) {
            DateTime date = (DateTime)leftValue;
            Period period = (Period)rightValue;
            return this.isPlus() ? date.plus((ReadablePeriod)period) : date.minus((ReadablePeriod)period);
        }
        if (leftPeriod && rightDate) {
            DateTime date = (DateTime)rightValue;
            Period period = (Period)leftValue;
            return this.isPlus() ? date.plus((ReadablePeriod)period) : date.minus((ReadablePeriod)period);
        }
        if (leftPeriod && rightPeriod) {
            Period period1 = (Period)leftValue;
            Period period2 = (Period)rightValue;
            return this.isPlus() ? period1.plus((ReadablePeriod)period2) : period1.minus((ReadablePeriod)period2);
        }
        if (leftDate && rightDate) {
            if (this.isPlus()) {
                return null;
            }
            DateTime left = (DateTime)leftValue;
            DateTime right = (DateTime)rightValue;
            if (left.isBefore((ReadableInstant)right)) {
                return new Duration((ReadableInstant)left, (ReadableInstant)right);
            }
            return new Duration((ReadableInstant)right, (ReadableInstant)left);
        }
        if (String.class.equals((Object)this.type)) {
            if (!this.isPlus) {
                return null;
            }
            String left = String.valueOf(leftValue);
            String right = String.valueOf(rightValue);
            return left + right;
        }
        if (this.isIntegral()) {
            long l = (Long)leftValue;
            long r = (Long)rightValue;
            if (this.isPlus) {
                return l + r;
            }
            return l - r;
        }
        double l = (Double)leftValue;
        double r = (Double)rightValue;
        if (this.isPlus) {
            return l + r;
        }
        return l - r;
    }

    public boolean isPlus() {
        return this.isPlus;
    }

    @Override
    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String toString() {
        return this.left.toString() + (this.isPlus ? " + " : " - ") + this.right.toString();
    }
}

