/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.sidecar.services;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.graylog.plugins.sidecar.rest.models.CollectorUpload;
import org.graylog2.bindings.providers.MongoJackObjectMapperProvider;
import org.graylog2.database.MongoConnection;
import org.graylog2.database.PaginatedDbService;
import org.graylog2.database.PaginatedList;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePeriod;
import org.mongojack.DBQuery;
import org.mongojack.DBSort;

public class ImportService
extends PaginatedDbService<CollectorUpload> {
    private static final String COLLECTION_NAME = "collector_uploads";

    @Inject
    public ImportService(MongoConnection mongoConnection, MongoJackObjectMapperProvider mapper) {
        super(mongoConnection, mapper, CollectorUpload.class, COLLECTION_NAME);
    }

    public PaginatedList<CollectorUpload> findPaginated(int page, int perPage, String sortField, String order) {
        DBSort.SortBuilder sortBuilder = this.getSortBuilder(order, sortField);
        return this.findPaginatedWithQueryAndSort(DBQuery.empty(), sortBuilder, page, perPage);
    }

    public List<CollectorUpload> all() {
        try (Stream collectorUploadStream = this.streamAll();){
            List<CollectorUpload> list = collectorUploadStream.collect(Collectors.toList());
            return list;
        }
    }

    public long count() {
        return this.db.count();
    }

    public int destroyExpired(Period period) {
        int count;
        DateTime threshold = DateTime.now((DateTimeZone)DateTimeZone.UTC).minus((ReadablePeriod)period);
        try (Stream uploadStream = this.streamAll();){
            count = uploadStream.mapToInt(upload -> {
                if (upload.created().isBefore((ReadableInstant)threshold)) {
                    return this.delete(upload.id());
                }
                return 0;
            }).sum();
        }
        return count;
    }
}

