/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.auto.value.AutoValue;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.RandomUUIDProvider;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.TimeRange;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.ViewWidget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.Widget;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.ApproximatedAutoIntervalFactory;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.AutoValue_QuickValuesHistogramConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfigBase;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.dashboardwidgets.WidgetConfigWithQueryAndStreams;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AggregationConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.AutoInterval;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.BarVisualizationConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Pivot;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.Series;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.SeriesSortConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.SortConfig;
import org.graylog.plugins.views.migrations.V20191125144500_MigrateDashboardsToViewsSupport.viewwidgets.TimeHistogramConfig;

@JsonAutoDetect
@JsonIgnoreProperties(ignoreUnknown=true)
@AutoValue
public abstract class QuickValuesHistogramConfig
extends WidgetConfigBase
implements WidgetConfigWithQueryAndStreams {
    private static final String BAR_VISUALIZATION = "bar";

    public abstract String field();

    public abstract Integer limit();

    public abstract String sortOrder();

    public abstract String stackedFields();

    public abstract Optional<String> interval();

    private Series series() {
        return this.countSeries();
    }

    private SortConfig.Direction order() {
        return this.sortDirection(this.sortOrder());
    }

    private SortConfig sort() {
        return SeriesSortConfig.create(this.field(), this.order());
    }

    private List<Pivot> stackedFieldPivots() {
        Pivot fieldPivot = this.valuesPivotForField(this.field(), this.limit());
        List stackedFieldsPivots = Strings.isNullOrEmpty((String)this.stackedFields()) ? Collections.emptyList() : Splitter.on((String)",").splitToList((CharSequence)this.stackedFields()).stream().map(fieldName -> this.valuesPivotForField((String)fieldName, this.limit())).collect(Collectors.toList());
        return ImmutableList.builder().add((Object)fieldPivot).addAll(stackedFieldsPivots).build();
    }

    @Override
    public Set<ViewWidget> toViewWidgets(Widget widget, RandomUUIDProvider randomUUIDProvider) {
        return Collections.singleton(this.createAggregationWidget(randomUUIDProvider.get()).config(AggregationConfig.builder().rowPivots(Collections.singletonList(Pivot.timeBuilder().field(TIMESTAMP_FIELD).config(TimeHistogramConfig.builder().interval(this.interval().map(interval -> ApproximatedAutoIntervalFactory.of(interval, this.timerange())).orElse(AutoInterval.create())).build()).build())).columnPivots(this.stackedFieldPivots()).series(Collections.singletonList(this.series())).sort(Collections.singletonList(this.sort())).visualization(BAR_VISUALIZATION).visualizationConfig(BarVisualizationConfig.builder().barmode(BarVisualizationConfig.BarMode.stack).build()).build()).build());
    }

    @JsonCreator
    static QuickValuesHistogramConfig create(@JsonProperty(value="query") @Nullable String query, @JsonProperty(value="timerange") TimeRange timerange, @JsonProperty(value="field") String field, @JsonProperty(value="limit") Integer limit, @JsonProperty(value="sort_order") String sortOrder, @JsonProperty(value="stacked_fields") String stackedFields, @JsonProperty(value="interval") @Nullable String interval, @JsonProperty(value="stream_id") @Nullable String streamId) {
        return new AutoValue_QuickValuesHistogramConfig(timerange, Strings.nullToEmpty((String)query), Optional.ofNullable(streamId), field, limit, sortOrder, stackedFields, Optional.ofNullable(interval));
    }
}

