/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import java.util.List;
import java.util.function.Function;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.graylog.plugins.views.search.searchtypes.Sort;

public class MessagesSpecToMessageListMapper
implements Function<MessagesRequestSpec, MessageList> {
    public static final String MESSAGE_LIST_ID = "scripting_api_temporary_message_list";

    @Override
    public MessageList apply(MessagesRequestSpec messagesRequestSpec) {
        MessageList.Builder messageListBuilder = MessageList.builder().id(MESSAGE_LIST_ID).sort(this.createSort(messagesRequestSpec)).limit(messagesRequestSpec.size()).offset(messagesRequestSpec.from()).fields(messagesRequestSpec.fields());
        return messageListBuilder.build();
    }

    private List<Sort> createSort(MessagesRequestSpec messagesRequestSpec) {
        if (messagesRequestSpec.sort() == null || messagesRequestSpec.sort().equals("timestamp")) {
            Sort.Order order = messagesRequestSpec.sortOrder().toSortOrder();
            return List.of(Sort.create("timestamp", order), Sort.create("gl2_message_id", order));
        }
        return List.of(Sort.create(messagesRequestSpec.sort(), messagesRequestSpec.sortOrder().toSortOrder()));
    }
}

