/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.plugins.views.search.rest.scriptingapi.mapping;

import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.FieldTypesLookup;
import org.graylog.plugins.views.search.permissions.SearchUser;
import org.graylog.plugins.views.search.rest.SearchJobDTO;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.QueryFailedException;
import org.graylog.plugins.views.search.rest.scriptingapi.mapping.TabularResponseCreator;
import org.graylog.plugins.views.search.rest.scriptingapi.request.MessagesRequestSpec;
import org.graylog.plugins.views.search.rest.scriptingapi.response.Metadata;
import org.graylog.plugins.views.search.rest.scriptingapi.response.TabularResponse;
import org.graylog.plugins.views.search.searchtypes.MessageList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesTabularResponseCreator
implements TabularResponseCreator {
    private static final Logger LOG = LoggerFactory.getLogger(MessagesTabularResponseCreator.class);
    private final FieldTypesLookup fieldTypesLookup;

    @Inject
    public MessagesTabularResponseCreator(FieldTypesLookup fieldTypesLookup) {
        this.fieldTypesLookup = fieldTypesLookup;
    }

    public TabularResponse mapToResponse(MessagesRequestSpec messagesRequestSpec, SearchJob searchJob, SearchUser searchUser) throws QueryFailedException {
        SearchJobDTO searchJobDTO = SearchJobDTO.fromSearchJob(searchJob);
        QueryResult queryResult = searchJobDTO.results().get("scripting_api_temporary_query");
        if (queryResult != null) {
            this.throwErrorIfAnyAvailable(queryResult);
            SearchType.Result messageListResult = queryResult.searchTypes().get("scripting_api_temporary_message_list");
            if (messageListResult instanceof MessageList.Result) {
                MessageList.Result messagesResult = (MessageList.Result)messageListResult;
                return this.mapToResponse(messagesRequestSpec, messagesResult, searchUser);
            }
        }
        LOG.warn("Scripting API failed to obtain messages for input : " + messagesRequestSpec);
        throw new QueryFailedException("Scripting API failed to obtain messages for input : " + messagesRequestSpec);
    }

    private TabularResponse mapToResponse(MessagesRequestSpec searchRequestSpec, MessageList.Result messageListResult, SearchUser searchUser) {
        ImmutableSet<String> streams = searchUser.streams().readableOrAllIfEmpty(searchRequestSpec.streams());
        Map<String, String> fieldTypes = this.fieldTypesLookup.getTypes((Set<String>)streams, (Set<String>)new HashSet<String>(searchRequestSpec.fields()));
        return new TabularResponse(searchRequestSpec.getSchema(fieldTypes), MessagesTabularResponseCreator.getDatarows(searchRequestSpec, messageListResult), new Metadata(messageListResult.effectiveTimerange()));
    }

    private static List<List<Object>> getDatarows(MessagesRequestSpec messagesRequestSpec, MessageList.Result messageListResult) {
        return messageListResult.messages().stream().map(message -> messagesRequestSpec.fields().stream().map(field -> message.message().get(field)).map(value -> value == null ? "-" : value).collect(Collectors.toList())).collect(Collectors.toList());
    }
}

